/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.http.async.AbortableInputStreamSubscriber;

@SdkInternalApi
public class InputStreamResponseTransformer<ResponseT extends SdkResponse>
implements AsyncResponseTransformer<ResponseT, ResponseInputStream<ResponseT>> {
    private volatile CompletableFuture<ResponseInputStream<ResponseT>> future;
    private volatile ResponseT response;
    private volatile WaitForSubscribeOnErrorWrapper subscriber;

    @Override
    public CompletableFuture<ResponseInputStream<ResponseT>> prepare() {
        CompletableFuture<ResponseInputStream<ResponseT>> result = new CompletableFuture<ResponseInputStream<ResponseT>>();
        this.future = result;
        return result;
    }

    @Override
    public void onResponse(ResponseT response) {
        this.response = response;
    }

    @Override
    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        WaitForSubscribeOnErrorWrapper waitForSubscribeSubscriber;
        AbortableInputStreamSubscriber inputStreamSubscriber = AbortableInputStreamSubscriber.builder().build();
        this.subscriber = waitForSubscribeSubscriber = new WaitForSubscribeOnErrorWrapper(inputStreamSubscriber);
        publisher.subscribe(waitForSubscribeSubscriber);
        this.future.complete(new ResponseInputStream<ResponseT>(this.response, (InputStream)inputStreamSubscriber));
    }

    @Override
    public void exceptionOccurred(Throwable error) {
        this.future.completeExceptionally(error);
        if (this.subscriber != null) {
            this.subscriber.onError(error);
        }
    }

    @Override
    public String name() {
        return AsyncResponseTransformer.TransformerType.STREAM.getName();
    }

    private static final class WaitForSubscribeOnErrorWrapper
    implements Subscriber<ByteBuffer> {
        private final Object lock = new Object();
        private final AbortableInputStreamSubscriber delegate;
        private boolean subscribed = false;
        private Throwable transformerException;

        private WaitForSubscribeOnErrorWrapper(AbortableInputStreamSubscriber delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            Object object = this.lock;
            synchronized (object) {
                this.subscribed = true;
                this.delegate.onSubscribe(s);
                if (this.transformerException != null) {
                    this.delegate.onError(this.transformerException);
                    this.transformerException = null;
                }
            }
        }

        public void onNext(ByteBuffer byteBuffer) {
            this.delegate.onNext(byteBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            Object object = this.lock;
            synchronized (object) {
                if (this.subscribed) {
                    this.delegate.onError(t);
                } else {
                    this.transformerException = t;
                }
            }
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }
}

