/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncRequestBodySplitConfiguration;
import software.amazon.awssdk.core.async.CloseableAsyncRequestBody;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.NonRetryableSubAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.RetryableSubAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.SubAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.SubAsyncRequestBodyConfiguration;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public class SplittingPublisher
implements SdkPublisher<CloseableAsyncRequestBody> {
    private static final Logger log = Logger.loggerFor(SplittingPublisher.class);
    private final AsyncRequestBody upstreamPublisher;
    private final SplittingSubscriber splittingSubscriber;
    private final SimplePublisher<CloseableAsyncRequestBody> downstreamPublisher = new SimplePublisher();
    private final long chunkSizeInBytes;
    private final long bufferSizeInBytes;
    private final boolean retryableSubAsyncRequestBodyEnabled;
    private final AtomicBoolean currentBodySent = new AtomicBoolean(false);
    private final String sourceBodyName;

    private SplittingPublisher(Builder builder) {
        this.upstreamPublisher = (AsyncRequestBody)Validate.paramNotNull((Object)builder.asyncRequestBody, (String)"asyncRequestBody");
        Validate.notNull((Object)builder.splitConfiguration, (String)"splitConfiguration", (Object[])new Object[0]);
        this.chunkSizeInBytes = builder.splitConfiguration.chunkSizeInBytes() == null ? AsyncRequestBodySplitConfiguration.defaultConfiguration().chunkSizeInBytes() : builder.splitConfiguration.chunkSizeInBytes();
        this.bufferSizeInBytes = builder.splitConfiguration.bufferSizeInBytes() == null ? AsyncRequestBodySplitConfiguration.defaultConfiguration().bufferSizeInBytes() : builder.splitConfiguration.bufferSizeInBytes();
        this.splittingSubscriber = new SplittingSubscriber(this.upstreamPublisher.contentLength().orElse(null));
        this.retryableSubAsyncRequestBodyEnabled = (Boolean)Validate.paramNotNull((Object)builder.retryableSubAsyncRequestBodyEnabled, (String)"retryableSubAsyncRequestBodyEnabled");
        this.sourceBodyName = builder.asyncRequestBody.body();
        if (!this.upstreamPublisher.contentLength().isPresent()) {
            Validate.isTrue((this.bufferSizeInBytes >= this.chunkSizeInBytes ? 1 : 0) != 0, (String)"bufferSizeInBytes must be larger than or equal to chunkSizeInBytes if the content length is unknown", (Object[])new Object[0]);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public void subscribe(Subscriber<? super CloseableAsyncRequestBody> downstreamSubscriber) {
        this.downstreamPublisher.subscribe(downstreamSubscriber);
        this.upstreamPublisher.subscribe(this.splittingSubscriber);
    }

    public static final class Builder {
        private AsyncRequestBody asyncRequestBody;
        private AsyncRequestBodySplitConfiguration splitConfiguration;
        private Boolean retryableSubAsyncRequestBodyEnabled;

        private Builder() {
        }

        public Builder asyncRequestBody(AsyncRequestBody asyncRequestBody) {
            this.asyncRequestBody = asyncRequestBody;
            return this;
        }

        public Builder splitConfiguration(AsyncRequestBodySplitConfiguration splitConfiguration) {
            this.splitConfiguration = splitConfiguration;
            return this;
        }

        public Builder retryableSubAsyncRequestBodyEnabled(Boolean retryableSubAsyncRequestBodyEnabled) {
            this.retryableSubAsyncRequestBodyEnabled = retryableSubAsyncRequestBodyEnabled;
            return this;
        }

        public SplittingPublisher build() {
            return new SplittingPublisher(this);
        }
    }

    private class SplittingSubscriber
    implements Subscriber<ByteBuffer> {
        private Subscription upstreamSubscription;
        private final Long upstreamSize;
        private final AtomicInteger partNumber = new AtomicInteger(1);
        private volatile SubAsyncRequestBody currentBody;
        private final AtomicBoolean hasOpenUpstreamDemand = new AtomicBoolean(false);
        private final AtomicLong dataBuffered = new AtomicLong(0L);
        private int byteBufferSizeHint;
        private volatile boolean upstreamComplete;

        SplittingSubscriber(Long upstreamSize) {
            this.upstreamSize = upstreamSize;
        }

        public void onSubscribe(Subscription s) {
            this.upstreamSubscription = s;
            this.currentBody = this.initializeNextDownstreamBody(this.upstreamSize != null, this.calculateChunkSize(this.upstreamSize), this.partNumber.get());
            this.upstreamSubscription.request(1L);
        }

        private SubAsyncRequestBody initializeNextDownstreamBody(boolean contentLengthKnown, long chunkSize, int chunkNumber) {
            log.debug(() -> "initializing next downstream body " + this.partNumber);
            SubAsyncRequestBodyConfiguration config = SubAsyncRequestBodyConfiguration.builder().contentLengthKnown(contentLengthKnown).maxLength(chunkSize).partNumber(chunkNumber).onNumBytesReceived(data -> this.addDataBuffered((long)data)).onNumBytesConsumed(data -> this.addDataBuffered(-data.longValue())).sourceBodyName(SplittingPublisher.this.sourceBodyName).build();
            SubAsyncRequestBody body = SplittingPublisher.this.retryableSubAsyncRequestBodyEnabled ? new RetryableSubAsyncRequestBody(config) : new NonRetryableSubAsyncRequestBody(config);
            SplittingPublisher.this.currentBodySent.set(false);
            if (contentLengthKnown) {
                this.sendCurrentBody(body);
            }
            return body;
        }

        public void onNext(ByteBuffer byteBuffer) {
            this.hasOpenUpstreamDemand.set(false);
            this.byteBufferSizeHint = byteBuffer.remaining();
            while (byteBuffer.hasRemaining()) {
                int amountRemainingInChunk = this.amountRemainingInChunk();
                if (amountRemainingInChunk == 0) {
                    this.completeCurrentBodyAndCreateNewIfNeeded(byteBuffer);
                    amountRemainingInChunk = this.amountRemainingInChunk();
                }
                if (amountRemainingInChunk > byteBuffer.remaining()) {
                    this.currentBody.send(byteBuffer.duplicate());
                    break;
                }
                if (amountRemainingInChunk == byteBuffer.remaining()) {
                    this.currentBody.send(byteBuffer.duplicate());
                    this.completeCurrentBodyAndCreateNewIfNeeded(byteBuffer);
                    break;
                }
                ByteBuffer firstHalf = byteBuffer.duplicate();
                int newLimit = firstHalf.position() + amountRemainingInChunk;
                firstHalf.limit(newLimit);
                byteBuffer.position(newLimit);
                this.currentBody.send(firstHalf);
            }
            this.maybeRequestMoreUpstreamData();
        }

        private void completeCurrentBodyAndCreateNewIfNeeded(ByteBuffer byteBuffer) {
            boolean shouldCreateNewDownstreamRequestBody;
            this.completeCurrentBody();
            int nextChunk = this.partNumber.incrementAndGet();
            Long dataRemaining = this.totalDataRemaining();
            if (this.upstreamSize == null) {
                shouldCreateNewDownstreamRequestBody = !this.upstreamComplete || byteBuffer.hasRemaining();
            } else {
                boolean bl = shouldCreateNewDownstreamRequestBody = dataRemaining != null && dataRemaining > 0L;
            }
            if (shouldCreateNewDownstreamRequestBody) {
                long chunkSize = this.calculateChunkSize(dataRemaining);
                this.currentBody = this.initializeNextDownstreamBody(this.upstreamSize != null, chunkSize, nextChunk);
            }
        }

        private int amountRemainingInChunk() {
            return Math.toIntExact(this.currentBody.maxLength() - this.currentBody.receivedBytesLength());
        }

        private void completeCurrentBody() {
            log.debug(() -> "completeCurrentBody for part " + this.currentBody.partNumber());
            long bufferedLength = this.currentBody.receivedBytesLength();
            if (bufferedLength == 0L) {
                return;
            }
            Long totalLength = this.currentBody.maxLength();
            if (this.upstreamSize != null && totalLength != bufferedLength) {
                this.upstreamSubscription.cancel();
                SplittingPublisher.this.downstreamPublisher.error((Throwable)new IllegalStateException(String.format("Content length of buffered data mismatches with the expected content length, buffered data content length: %d, expected length: %d", totalLength, bufferedLength)));
                return;
            }
            this.currentBody.complete();
            if (this.upstreamSize == null && SplittingPublisher.this.currentBodySent.compareAndSet(false, true)) {
                this.sendCurrentBody(this.currentBody);
            }
        }

        public void onComplete() {
            this.upstreamComplete = true;
            log.debug(() -> "Received onComplete()");
            this.completeCurrentBody();
            SplittingPublisher.this.downstreamPublisher.complete();
        }

        public void onError(Throwable t) {
            log.debug(() -> "Received onError()", t);
            SplittingPublisher.this.downstreamPublisher.error(t);
        }

        private void sendCurrentBody(SubAsyncRequestBody body) {
            log.debug(() -> "sendCurrentBody for part " + body.partNumber());
            SplittingPublisher.this.downstreamPublisher.send((Object)body).exceptionally(t -> {
                SplittingPublisher.this.downstreamPublisher.error(t);
                this.upstreamSubscription.cancel();
                return null;
            });
        }

        private long calculateChunkSize(Long dataRemaining) {
            if (dataRemaining == null) {
                return SplittingPublisher.this.chunkSizeInBytes;
            }
            return Math.min(SplittingPublisher.this.chunkSizeInBytes, dataRemaining);
        }

        private void maybeRequestMoreUpstreamData() {
            long buffered = this.dataBuffered.get();
            if (this.shouldRequestMoreData(buffered) && this.hasOpenUpstreamDemand.compareAndSet(false, true)) {
                log.trace(() -> "Requesting more data, current data buffered: " + buffered);
                this.upstreamSubscription.request(1L);
            } else {
                log.trace(() -> "Should not request more data, current data buffered: " + buffered);
            }
        }

        private boolean shouldRequestMoreData(long buffered) {
            return buffered <= 0L || buffered + (long)this.byteBufferSizeHint <= SplittingPublisher.this.bufferSizeInBytes;
        }

        private Long totalDataRemaining() {
            if (this.upstreamSize == null) {
                return null;
            }
            return this.upstreamSize - (long)(this.partNumber.get() - 1) * SplittingPublisher.this.chunkSizeInBytes;
        }

        private void addDataBuffered(long length) {
            log.trace(() -> "Adding data buffered " + length);
            this.dataBuffered.addAndGet(length);
            if (length < 0L) {
                this.maybeRequestMoreUpstreamData();
            }
        }
    }
}

