/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkInternalApi
public enum IdentityProviderNameMapping {
    SYS("SystemPropertyCredentialsProvider"),
    ENV("EnvironmentVariableCredentialsProvider"),
    STSWEB("StsAssumeRoleWithWebIdentityCredentialsProvider"),
    STSROLE("StsAssumeRoleCredentialsProvider"),
    STSSAML("StsAssumeRoleWithSamlCredentialsProvider"),
    STSFED("StsGetFederationTokenCredentialsProvider"),
    STSSESS("StsGetSessionTokenCredentialsProvider"),
    SSO("SsoCredentialsProvider"),
    PROF("ProfileCredentialsProvider"),
    CONT("ContainerCredentialsProvider"),
    IMDS("InstanceProfileCredentialsProvider"),
    STAT("StaticCredentialsProvider"),
    PROC("ProcessCredentialsProvider"),
    ANON("AnonymousCredentialsProvider"),
    UNKNOWN("Unknown");

    private static final Pattern CLASS_NAME_CHARACTERS;
    private static final Map<String, IdentityProviderNameMapping> VALUE_MAP;
    private final String value;

    private IdentityProviderNameMapping(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Optional<String> mapFrom(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return Optional.of(UNKNOWN.name().toLowerCase(Locale.US));
        }
        return IdentityProviderNameMapping.mappedName(source).map(mapping -> Optional.of(mapping.name().toLowerCase(Locale.US))).orElseGet(() -> IdentityProviderNameMapping.sanitizedProviderOrNull(source));
    }

    private static Optional<IdentityProviderNameMapping> mappedName(String value) {
        if (VALUE_MAP.containsKey(value)) {
            return Optional.of(VALUE_MAP.get(value));
        }
        return Optional.empty();
    }

    private static Optional<String> sanitizedProviderOrNull(String value) {
        if (IdentityProviderNameMapping.hasAcceptedFormat(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean hasAcceptedFormat(String input) {
        return CLASS_NAME_CHARACTERS.matcher(input).matches();
    }

    static {
        CLASS_NAME_CHARACTERS = Pattern.compile("[a-zA-Z_$\\d]{0,62}");
        VALUE_MAP = EnumUtils.uniqueIndex(IdentityProviderNameMapping.class, IdentityProviderNameMapping::toString);
    }
}

