/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.sync;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.internal.sync.BufferingContentStreamProvider;
import software.amazon.awssdk.core.internal.sync.FileContentStreamProvider;
import software.amazon.awssdk.core.internal.util.Mimetype;
import software.amazon.awssdk.core.io.ReleasableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public class RequestBody {
    private final ContentStreamProvider contentStreamProvider;
    private final Long contentLength;
    private final String contentType;

    @SdkInternalApi
    protected RequestBody(ContentStreamProvider contentStreamProvider, Long contentLength, String contentType) {
        this.contentStreamProvider = (ContentStreamProvider)Validate.paramNotNull((Object)contentStreamProvider, (String)"contentStreamProvider");
        this.contentLength = contentLength != null ? Long.valueOf(Validate.isNotNegative((long)contentLength, (String)"Content-length")) : null;
        this.contentType = (String)Validate.paramNotNull((Object)contentType, (String)"contentType");
    }

    public final ContentStreamProvider contentStreamProvider() {
        return this.contentStreamProvider;
    }

    @Deprecated
    public final long contentLength() {
        Validate.validState((this.contentLength != null ? 1 : 0) != 0, (String)"Content length is invalid, please use optionalContentLength() for your case.", (Object[])new Object[0]);
        return this.contentLength;
    }

    public final Optional<Long> optionalContentLength() {
        return Optional.ofNullable(this.contentLength);
    }

    public final String contentType() {
        return this.contentType;
    }

    public static RequestBody fromFile(Path path) {
        return new RequestBody(new FileContentStreamProvider(path), (Long)FunctionalUtils.invokeSafely(() -> Files.size(path)), Mimetype.getInstance().getMimetype(path));
    }

    public static RequestBody fromFile(File file) {
        return RequestBody.fromFile(file.toPath());
    }

    public static RequestBody fromInputStream(InputStream inputStream, long contentLength) {
        ContentStreamProvider contentStreamProvider = ContentStreamProvider.fromInputStream((InputStream)RequestBody.nonCloseableInputStream(inputStream));
        return RequestBody.fromContentProvider(contentStreamProvider, contentLength, "application/octet-stream");
    }

    public static RequestBody fromString(String contents, Charset cs) {
        return RequestBody.fromBytesDirect(contents.getBytes(cs), "text/plain; charset=" + cs.name());
    }

    public static RequestBody fromString(String contents) {
        return RequestBody.fromString(contents, StandardCharsets.UTF_8);
    }

    public static RequestBody fromBytes(byte[] bytes) {
        return RequestBody.fromBytesDirect(Arrays.copyOf(bytes, bytes.length));
    }

    public static RequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return RequestBody.fromBytesDirect(BinaryUtils.copyAllBytesFrom((ByteBuffer)byteBuffer));
    }

    public static RequestBody fromRemainingByteBuffer(ByteBuffer byteBuffer) {
        return RequestBody.fromBytesDirect(BinaryUtils.copyRemainingBytesFrom((ByteBuffer)byteBuffer));
    }

    public static RequestBody empty() {
        return RequestBody.fromBytesDirect(new byte[0]);
    }

    public static RequestBody fromContentProvider(ContentStreamProvider provider, long contentLength, String mimeType) {
        return new RequestBody(provider, contentLength, mimeType);
    }

    public static RequestBody fromContentProvider(ContentStreamProvider provider, String mimeType) {
        return new RequestBody(new BufferingContentStreamProvider(provider, null), null, mimeType);
    }

    private static RequestBody fromBytesDirect(byte[] bytes) {
        return RequestBody.fromBytesDirect(bytes, "application/octet-stream");
    }

    private static RequestBody fromBytesDirect(byte[] bytes, String mimetype) {
        return new RequestBody(ContentStreamProvider.fromByteArrayUnsafe((byte[])bytes), Long.valueOf(bytes.length), mimetype);
    }

    private static InputStream nonCloseableInputStream(InputStream inputStream) {
        return inputStream != null ? (InputStream)ReleasableInputStream.wrap(inputStream).disableClose() : null;
    }
}

