/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;

public class ListNamedQueriesIterable
implements SdkIterable<ListNamedQueriesResponse> {
    private final AthenaClient client;
    private final ListNamedQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNamedQueriesIterable(AthenaClient client, ListNamedQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNamedQueriesResponseFetcher();
    }

    public Iterator<ListNamedQueriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNamedQueriesResponseFetcher
    implements SyncPageFetcher<ListNamedQueriesResponse> {
        private ListNamedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamedQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNamedQueriesResponse nextPage(ListNamedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListNamedQueriesIterable.this.client.listNamedQueries(ListNamedQueriesIterable.this.firstRequest);
            }
            return ListNamedQueriesIterable.this.client.listNamedQueries((ListNamedQueriesRequest)((Object)ListNamedQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

