/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.endpoints.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.endpoints.EndpointAttributeKey;
import software.amazon.awssdk.services.s3.endpoints.internal.EndpointAttributeProvider;
import software.amazon.awssdk.services.s3.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.s3.endpoints.internal.S3EndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.s3.endpoints.internal.Value;

@SdkInternalApi
public final class KnownS3ExpressEndpointProperty {
    public static final EndpointAttributeKey<String> BACKEND = new EndpointAttributeKey("Backend", String.class);
    public static final List<EndpointAttributeProvider<?>> KNOWN_S3_ENDPOINT_PROPERTIES = Collections.unmodifiableList(Arrays.asList(new AuthSchemesProperty(), new BackendProperty()));

    private KnownS3ExpressEndpointProperty() {
    }

    private static class AuthSchemesProperty
    implements EndpointAttributeProvider<List<EndpointAuthScheme>> {
        private AuthSchemesProperty() {
        }

        @Override
        public String propertyName() {
            return "authSchemes";
        }

        @Override
        public EndpointAttributeKey<List<EndpointAuthScheme>> attributeKey() {
            return AwsEndpointAttribute.AUTH_SCHEMES;
        }

        @Override
        public List<EndpointAuthScheme> attributeValue(Value value) {
            S3EndpointAuthSchemeStrategyFactory endpointAuthSchemeStrategyFactory = new S3EndpointAuthSchemeStrategyFactory();
            EndpointAuthSchemeStrategy strategy = endpointAuthSchemeStrategyFactory.endpointAuthSchemeStrategy();
            return strategy.createAuthSchemes(value);
        }
    }

    private static class BackendProperty
    implements EndpointAttributeProvider<String> {
        private BackendProperty() {
        }

        @Override
        public String propertyName() {
            return "backend";
        }

        @Override
        public EndpointAttributeKey<String> attributeKey() {
            return BACKEND;
        }

        @Override
        public String attributeValue(Value value) {
            return value.expectString();
        }
    }
}

