/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.CustomParameter;
import software.amazon.awssdk.services.datazone.model.CustomParameterListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.ProvisioningProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentBlueprintRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentBlueprintRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentBlueprintRequest.getter(CreateEnvironmentBlueprintRequest::description)).setter(CreateEnvironmentBlueprintRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateEnvironmentBlueprintRequest.getter(CreateEnvironmentBlueprintRequest::domainIdentifier)).setter(CreateEnvironmentBlueprintRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentBlueprintRequest.getter(CreateEnvironmentBlueprintRequest::name)).setter(CreateEnvironmentBlueprintRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisioningProperties").getter(CreateEnvironmentBlueprintRequest.getter(CreateEnvironmentBlueprintRequest::provisioningProperties)).setter(CreateEnvironmentBlueprintRequest.setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build()}).build();
    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userParameters").getter(CreateEnvironmentBlueprintRequest.getter(CreateEnvironmentBlueprintRequest::userParameters)).setter(CreateEnvironmentBlueprintRequest.setter(Builder::userParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, PROVISIONING_PROPERTIES_FIELD, USER_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentBlueprintRequest.memberNameToFieldInitializer();
    private final String description;
    private final String domainIdentifier;
    private final String name;
    private final ProvisioningProperties provisioningProperties;
    private final List<CustomParameter> userParameters;

    private CreateEnvironmentBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.provisioningProperties = builder.provisioningProperties;
        this.userParameters = builder.userParameters;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final ProvisioningProperties provisioningProperties() {
        return this.provisioningProperties;
    }

    public final boolean hasUserParameters() {
        return this.userParameters != null && !(this.userParameters instanceof SdkAutoConstructList);
    }

    public final List<CustomParameter> userParameters() {
        return this.userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserParameters() ? this.userParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentBlueprintRequest)) {
            return false;
        }
        CreateEnvironmentBlueprintRequest other = (CreateEnvironmentBlueprintRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningProperties(), other.provisioningProperties()) && this.hasUserParameters() == other.hasUserParameters() && Objects.equals(this.userParameters(), other.userParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentBlueprintRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Name", (Object)this.name()).add("ProvisioningProperties", (Object)this.provisioningProperties()).add("UserParameters", this.hasUserParameters() ? this.userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provisioningProperties": {
                return Optional.ofNullable(clazz.cast(this.provisioningProperties()));
            }
            case "userParameters": {
                return Optional.ofNullable(clazz.cast(this.userParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provisioningProperties", PROVISIONING_PROPERTIES_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentBlueprintRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentBlueprintRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private String name;
        private ProvisioningProperties provisioningProperties;
        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentBlueprintRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.name(model.name);
            this.provisioningProperties(model.provisioningProperties);
            this.userParameters(model.userParameters);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return this.provisioningProperties != null ? this.provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter ... userParameters) {
            this.userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder> ... userParameters) {
            this.userParameters(Stream.of(userParameters).map(c -> (CustomParameter)((CustomParameter.Builder)CustomParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentBlueprintRequest build() {
            return new CreateEnvironmentBlueprintRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentBlueprintRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder name(String var1);

        public Builder provisioningProperties(ProvisioningProperties var1);

        default public Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return this.provisioningProperties((ProvisioningProperties)((ProvisioningProperties.Builder)ProvisioningProperties.builder().applyMutation(provisioningProperties)).build());
        }

        public Builder userParameters(Collection<CustomParameter> var1);

        public Builder userParameters(CustomParameter ... var1);

        public Builder userParameters(Consumer<CustomParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

