/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.SortKey;
import software.amazon.awssdk.services.datazone.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscriptionGrantsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListSubscriptionGrantsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::domainIdentifier)).setter(ListSubscriptionGrantsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::environmentId)).setter(ListSubscriptionGrantsRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::maxResults)).setter(ListSubscriptionGrantsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::nextToken)).setter(ListSubscriptionGrantsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> OWNING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningGroupId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::owningGroupId)).setter(ListSubscriptionGrantsRequest.setter(Builder::owningGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningGroupId").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::owningProjectId)).setter(ListSubscriptionGrantsRequest.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningProjectId").build()}).build();
    private static final SdkField<String> OWNING_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningUserId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::owningUserId)).setter(ListSubscriptionGrantsRequest.setter(Builder::owningUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningUserId").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::sortByAsString)).setter(ListSubscriptionGrantsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::sortOrderAsString)).setter(ListSubscriptionGrantsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final SdkField<String> SUBSCRIBED_LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscribedListingId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::subscribedListingId)).setter(ListSubscriptionGrantsRequest.setter(Builder::subscribedListingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscribedListingId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::subscriptionId)).setter(ListSubscriptionGrantsRequest.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscriptionId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionTargetId").getter(ListSubscriptionGrantsRequest.getter(ListSubscriptionGrantsRequest::subscriptionTargetId)).setter(ListSubscriptionGrantsRequest.setter(Builder::subscriptionTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscriptionTargetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNING_GROUP_ID_FIELD, OWNING_PROJECT_ID_FIELD, OWNING_USER_ID_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, SUBSCRIBED_LISTING_ID_FIELD, SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_TARGET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubscriptionGrantsRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final String environmentId;
    private final Integer maxResults;
    private final String nextToken;
    private final String owningGroupId;
    private final String owningProjectId;
    private final String owningUserId;
    private final String sortBy;
    private final String sortOrder;
    private final String subscribedListingId;
    private final String subscriptionId;
    private final String subscriptionTargetId;

    private ListSubscriptionGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentId = builder.environmentId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.owningGroupId = builder.owningGroupId;
        this.owningProjectId = builder.owningProjectId;
        this.owningUserId = builder.owningUserId;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.subscribedListingId = builder.subscribedListingId;
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionTargetId = builder.subscriptionTargetId;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String owningGroupId() {
        return this.owningGroupId;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String owningUserId() {
        return this.owningUserId;
    }

    @Deprecated
    public final SortKey sortBy() {
        return SortKey.fromValue(this.sortBy);
    }

    @Deprecated
    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String subscribedListingId() {
        return this.subscribedListingId;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public final String subscriptionTargetId() {
        return this.subscriptionTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedListingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTargetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionGrantsRequest)) {
            return false;
        }
        ListSubscriptionGrantsRequest other = (ListSubscriptionGrantsRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.owningGroupId(), other.owningGroupId()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.owningUserId(), other.owningUserId()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.subscribedListingId(), other.subscribedListingId()) && Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.subscriptionTargetId(), other.subscriptionTargetId());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubscriptionGrantsRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentId", (Object)this.environmentId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OwningGroupId", (Object)this.owningGroupId()).add("OwningProjectId", (Object)this.owningProjectId()).add("OwningUserId", (Object)this.owningUserId()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("SubscribedListingId", (Object)this.subscribedListingId()).add("SubscriptionId", (Object)this.subscriptionId()).add("SubscriptionTargetId", (Object)this.subscriptionTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "owningGroupId": {
                return Optional.ofNullable(clazz.cast(this.owningGroupId()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "owningUserId": {
                return Optional.ofNullable(clazz.cast(this.owningUserId()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "subscribedListingId": {
                return Optional.ofNullable(clazz.cast(this.subscribedListingId()));
            }
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "subscriptionTargetId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTargetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("owningGroupId", OWNING_GROUP_ID_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("owningUserId", OWNING_USER_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("subscribedListingId", SUBSCRIBED_LISTING_ID_FIELD);
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionTargetId", SUBSCRIPTION_TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionGrantsRequest, T> g) {
        return obj -> g.apply((ListSubscriptionGrantsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String environmentId;
        private Integer maxResults;
        private String nextToken;
        private String owningGroupId;
        private String owningProjectId;
        private String owningUserId;
        private String sortBy;
        private String sortOrder;
        private String subscribedListingId;
        private String subscriptionId;
        private String subscriptionTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionGrantsRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentId(model.environmentId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.owningGroupId(model.owningGroupId);
            this.owningProjectId(model.owningProjectId);
            this.owningUserId(model.owningUserId);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.subscribedListingId(model.subscribedListingId);
            this.subscriptionId(model.subscriptionId);
            this.subscriptionTargetId(model.subscriptionTargetId);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwningGroupId() {
            return this.owningGroupId;
        }

        public final void setOwningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
        }

        @Override
        public final Builder owningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getOwningUserId() {
            return this.owningUserId;
        }

        public final void setOwningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
        }

        @Override
        public final Builder owningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
            return this;
        }

        @Deprecated
        public final String getSortBy() {
            return this.sortBy;
        }

        @Deprecated
        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Deprecated
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Deprecated
        public final Builder sortBy(SortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSubscribedListingId() {
            return this.subscribedListingId;
        }

        public final void setSubscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
        }

        @Override
        public final Builder subscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
            return this;
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionTargetId() {
            return this.subscriptionTargetId;
        }

        public final void setSubscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
        }

        @Override
        public final Builder subscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionGrantsRequest build() {
            return new ListSubscriptionGrantsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscriptionGrantsRequest> {
        public Builder domainIdentifier(String var1);

        public Builder environmentId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder owningGroupId(String var1);

        public Builder owningProjectId(String var1);

        public Builder owningUserId(String var1);

        @Deprecated
        public Builder sortBy(String var1);

        @Deprecated
        public Builder sortBy(SortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder subscribedListingId(String var1);

        public Builder subscriptionId(String var1);

        public Builder subscriptionTargetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

