/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AssetListing;
import software.amazon.awssdk.services.datazone.model.DataProductListing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListingItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListingItem> {
    private static final SdkField<AssetListing> ASSET_LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetListing").getter(ListingItem.getter(ListingItem::assetListing)).setter(ListingItem.setter(Builder::assetListing)).constructor(AssetListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListing").build()}).build();
    private static final SdkField<DataProductListing> DATA_PRODUCT_LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataProductListing").getter(ListingItem.getter(ListingItem::dataProductListing)).setter(ListingItem.setter(Builder::dataProductListing)).constructor(DataProductListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductListing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTING_FIELD, DATA_PRODUCT_LISTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListingItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetListing assetListing;
    private final DataProductListing dataProductListing;
    private final Type type;

    private ListingItem(BuilderImpl builder) {
        this.assetListing = builder.assetListing;
        this.dataProductListing = builder.dataProductListing;
        this.type = builder.type;
    }

    public final AssetListing assetListing() {
        return this.assetListing;
    }

    public final DataProductListing dataProductListing() {
        return this.dataProductListing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetListing());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductListing());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListingItem)) {
            return false;
        }
        ListingItem other = (ListingItem)obj;
        return Objects.equals(this.assetListing(), other.assetListing()) && Objects.equals(this.dataProductListing(), other.dataProductListing());
    }

    public final String toString() {
        return ToString.builder((String)"ListingItem").add("AssetListing", (Object)this.assetListing()).add("DataProductListing", (Object)this.dataProductListing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetListing": {
                return Optional.ofNullable(clazz.cast(this.assetListing()));
            }
            case "dataProductListing": {
                return Optional.ofNullable(clazz.cast(this.dataProductListing()));
            }
        }
        return Optional.empty();
    }

    public static ListingItem fromAssetListing(AssetListing assetListing) {
        return (ListingItem)ListingItem.builder().assetListing(assetListing).build();
    }

    public static ListingItem fromAssetListing(Consumer<AssetListing.Builder> assetListing) {
        AssetListing.Builder builder = AssetListing.builder();
        assetListing.accept(builder);
        return ListingItem.fromAssetListing((AssetListing)builder.build());
    }

    public static ListingItem fromDataProductListing(DataProductListing dataProductListing) {
        return (ListingItem)ListingItem.builder().dataProductListing(dataProductListing).build();
    }

    public static ListingItem fromDataProductListing(Consumer<DataProductListing.Builder> dataProductListing) {
        DataProductListing.Builder builder = DataProductListing.builder();
        dataProductListing.accept(builder);
        return ListingItem.fromDataProductListing((DataProductListing)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetListing", ASSET_LISTING_FIELD);
        map.put("dataProductListing", DATA_PRODUCT_LISTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListingItem, T> g) {
        return obj -> g.apply((ListingItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetListing assetListing;
        private DataProductListing dataProductListing;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListingItem model) {
            this.assetListing(model.assetListing);
            this.dataProductListing(model.dataProductListing);
        }

        public final AssetListing.Builder getAssetListing() {
            return this.assetListing != null ? this.assetListing.toBuilder() : null;
        }

        public final void setAssetListing(AssetListing.BuilderImpl assetListing) {
            AssetListing oldValue = this.assetListing;
            this.assetListing = assetListing != null ? assetListing.build() : null;
            this.handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
        }

        @Override
        public final Builder assetListing(AssetListing assetListing) {
            AssetListing oldValue = this.assetListing;
            this.assetListing = assetListing;
            this.handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
            return this;
        }

        public final DataProductListing.Builder getDataProductListing() {
            return this.dataProductListing != null ? this.dataProductListing.toBuilder() : null;
        }

        public final void setDataProductListing(DataProductListing.BuilderImpl dataProductListing) {
            DataProductListing oldValue = this.dataProductListing;
            this.dataProductListing = dataProductListing != null ? dataProductListing.build() : null;
            this.handleUnionValueChange(Type.DATA_PRODUCT_LISTING, oldValue, this.dataProductListing);
        }

        @Override
        public final Builder dataProductListing(DataProductListing dataProductListing) {
            DataProductListing oldValue = this.dataProductListing;
            this.dataProductListing = dataProductListing;
            this.handleUnionValueChange(Type.DATA_PRODUCT_LISTING, oldValue, this.dataProductListing);
            return this;
        }

        public ListingItem build() {
            return new ListingItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        ASSET_LISTING,
        DATA_PRODUCT_LISTING,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListingItem> {
        public Builder assetListing(AssetListing var1);

        default public Builder assetListing(Consumer<AssetListing.Builder> assetListing) {
            return this.assetListing((AssetListing)((AssetListing.Builder)AssetListing.builder().applyMutation(assetListing)).build());
        }

        public Builder dataProductListing(DataProductListing var1);

        default public Builder dataProductListing(Consumer<DataProductListing.Builder> dataProductListing) {
            return this.dataProductListing((DataProductListing)((DataProductListing.Builder)DataProductListing.builder().applyMutation(dataProductListing)).build());
        }
    }
}

