/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DomainUnitSummary;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse;

public class ListDomainUnitsForParentIterable
implements SdkIterable<ListDomainUnitsForParentResponse> {
    private final DataZoneClient client;
    private final ListDomainUnitsForParentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainUnitsForParentIterable(DataZoneClient client, ListDomainUnitsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainUnitsForParentResponseFetcher();
    }

    public Iterator<ListDomainUnitsForParentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainUnitSummary> items() {
        Function<ListDomainUnitsForParentResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainUnitsForParentResponseFetcher
    implements SyncPageFetcher<ListDomainUnitsForParentResponse> {
        private ListDomainUnitsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainUnitsForParentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainUnitsForParentResponse nextPage(ListDomainUnitsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListDomainUnitsForParentIterable.this.client.listDomainUnitsForParent(ListDomainUnitsForParentIterable.this.firstRequest);
            }
            return ListDomainUnitsForParentIterable.this.client.listDomainUnitsForParent((ListDomainUnitsForParentRequest)((Object)ListDomainUnitsForParentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

