/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse;
import software.amazon.awssdk.services.datazone.model.ProjectMember;

public class ListProjectMembershipsIterable
implements SdkIterable<ListProjectMembershipsResponse> {
    private final DataZoneClient client;
    private final ListProjectMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectMembershipsIterable(DataZoneClient client, ListProjectMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProjectMembershipsResponseFetcher();
    }

    public Iterator<ListProjectMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProjectMember> members() {
        Function<ListProjectMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProjectMembershipsResponseFetcher
    implements SyncPageFetcher<ListProjectMembershipsResponse> {
        private ListProjectMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProjectMembershipsResponse nextPage(ListProjectMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectMembershipsIterable.this.client.listProjectMemberships(ListProjectMembershipsIterable.this.firstRequest);
            }
            return ListProjectMembershipsIterable.this.client.listProjectMemberships((ListProjectMembershipsRequest)((Object)ListProjectMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

