/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ProjectProfileSummary;

public class ListProjectProfilesPublisher
implements SdkPublisher<ListProjectProfilesResponse> {
    private final DataZoneAsyncClient client;
    private final ListProjectProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectProfilesPublisher(DataZoneAsyncClient client, ListProjectProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectProfilesPublisher(DataZoneAsyncClient client, ListProjectProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectProfileSummary> items() {
        Function<ListProjectProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProjectProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProjectProfilesResponseFetcher
    implements AsyncPageFetcher<ListProjectProfilesResponse> {
        private ListProjectProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProjectProfilesResponse> nextPage(ListProjectProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProjectProfilesPublisher.this.client.listProjectProfiles(ListProjectProfilesPublisher.this.firstRequest);
            }
            return ListProjectProfilesPublisher.this.client.listProjectProfiles((ListProjectProfilesRequest)((Object)ListProjectProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

