/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class AccessAnalyzerServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "access-analyzer";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-ca-central-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("me-west-1"), Region.of("mx-central-1"), Region.of("sa-east-1"), Region.of("sa-west-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-northeast-1"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-east-1-fips"), Region.of("us-gov-west-1"), Region.of("us-gov-west-1-fips"), Region.of("fips-us-iso-east-1"), Region.of("us-iso-east-1"), Region.of("us-iso-west-1"), Region.of("us-isob-east-1"), Region.of("us-isob-west-1"), Region.of("eu-isoe-west-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1"), Region.of("eusc-de-east-1"), Region.of("ap-isog-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null), new DefaultServicePartitionMetadata("aws-iso-g", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1-fips")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1-fips")).build(), (Object)"us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.af-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-northeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-northeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-northeast-3.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-south-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-3.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-4.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-5.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-6.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ap-southeast-7.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.ca-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.ca-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.ca-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-central-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-north-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-south-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-west-3.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"access-analyzer-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"access-analyzer-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"access-analyzer-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"access-analyzer-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"access-analyzer-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("il-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.il-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.me-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.me-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("me-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.me-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.mx-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.sa-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.sa-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-northeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.cn-north-1.api.amazonwebservices.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.cn-northwest-1.api.amazonwebservices.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eusc-de-east-1.api.amazonwebservices.eu").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), (Object)"access-analyzer-fips.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-iso-east-1.api.aws.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-iso-east-1.api.aws.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-iso-west-1.api.aws.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-iso-west-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-iso-west-1.api.aws.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-isob-east-1.api.aws.scloud").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-isob-east-1.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-isob-east-1.api.aws.scloud").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-isob-west-1.api.aws.scloud").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer-fips.us-isob-west-1.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-isob-west-1.api.aws.scloud").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.eu-isoe-west-1.api.cloud-aws.adc-e.uk").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-isof-east-1.api.aws.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-isof-south-1.api.aws.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"access-analyzer.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-gov-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer.us-gov-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1-fips")).build(), (Object)"access-analyzer.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"access-analyzer.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"access-analyzer.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"access-analyzer.us-gov-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"access-analyzer.us-gov-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1-fips")).build(), (Object)"access-analyzer.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

