/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class TextractServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "textract";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-ca-central-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("fips-us-iso-east-1"), Region.of("us-iso-east-1"), Region.of("us-isob-east-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-f", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), (Object)"us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.ap-northeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.ap-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.ap-southeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.ap-southeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.eu-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.eu-south-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.eu-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.eu-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.eu-west-3.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"textract-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"textract-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"textract-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"textract-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"textract-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), (Object)"textract-fips.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-isob-east-1.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), (Object)"textract-fips.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), (Object)"textract-fips.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-gov-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-gov-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"textract-fips.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"textract-fips.us-gov-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), (Object)"textract.us-gov-west-1.api.aws").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

