/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.ResultFormatHelper;
import com.amazon.athena.client.results.parsing.AthenaCsvParser;
import com.amazon.athena.client.results.parsing.AthenaTabSeparatedParser;
import com.amazon.athena.client.results.parsing.GetQueryResultsParser;
import com.amazon.athena.client.results.parsing.GetQueryResultsStreamResponseParser;
import com.amazon.athena.client.results.parsing.GetQueryResultsStreamResponseTabSeparatedParser;
import com.amazon.athena.client.results.parsing.GetQueryResultsTabSeparatedParser;
import com.amazon.athena.client.results.parsing.LineParser;
import com.amazon.athena.client.results.parsing.ResultRowsParser;
import com.amazon.athena.client.results.parsing.metadata.GetQueryResultsMetadataParser;
import com.amazon.athena.client.results.parsing.metadata.GetQueryResultsStaticMetadataParser;
import com.amazon.athena.client.results.parsing.metadata.GetQueryResultsStreamMetadataParser;
import com.amazon.athena.client.results.parsing.metadata.GetQueryResultsStreamStaticMetadataParser;
import com.amazon.athena.client.results.parsing.metadata.MetadataFetcher;
import com.amazon.athena.client.results.parsing.metadata.S3GetQueryResultsMetadataFetcher;
import com.amazon.athena.client.results.parsing.metadata.S3MetadataFetcher;
import com.amazon.athena.client.results.parsing.metadata.S3StaticMetadataFetcher;
import com.amazon.athena.logging.AthenaLogger;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class ResultParserFactory {
    private static final AthenaLogger logger = AthenaLogger.of(ResultParserFactory.class);
    public static final String SPLIT_PLAIN_TEXT_RESULTS = "splitplaintextresults";
    private final Set<String> legacyModes;
    private final int fetchSize;

    public ResultParserFactory() {
        this(Collections.emptySet(), 10000);
    }

    public ResultParserFactory(Set<String> legacyModes, int fetchSize) {
        this.legacyModes = legacyModes;
        this.fetchSize = fetchSize;
    }

    public GetQueryResultsParser createGetQueryResultsResultRowsParser(QueryExecution queryExecution) {
        if (ResultFormatHelper.isPlainTextResult(queryExecution)) {
            if (this.isSplitPlainTextResultsMode()) {
                logger.warn("Legacy mode SplitPlainTextResults is enabled. It is deprecated and its use can lead to incorrect query results", new Object[0]);
                logger.trace("Using GetQueryResultsTabSeparatedParser to parse results", new Object[0]);
                return new GetQueryResultsTabSeparatedParser(new GetQueryResultsMetadataParser());
            }
            logger.trace("Using GetQueryResultsParser to parse plain text results", new Object[0]);
            return new GetQueryResultsParser(new GetQueryResultsStaticMetadataParser());
        }
        logger.trace("Using GetQueryResultsParser to parse non plain text results", new Object[0]);
        return new GetQueryResultsParser(new GetQueryResultsMetadataParser());
    }

    public GetQueryResultsStreamResponseParser createGetQueryResultsStreamResultRowsParser(QueryExecution queryExecution) {
        if (ResultFormatHelper.isPlainTextResult(queryExecution)) {
            if (this.isSplitPlainTextResultsMode()) {
                logger.warn("Legacy mode SplitPlainTextResults is enabled. It is deprecated and its use can lead to incorrect query results", new Object[0]);
                logger.trace("Using GetQueryResultsStreamResponseTabSeparatedParser to parse results", new Object[0]);
                return new GetQueryResultsStreamResponseTabSeparatedParser(this.fetchSize, new GetQueryResultsStreamMetadataParser());
            }
            logger.trace("Using GetQueryResultsStreamResponseParser to parse plain text results", new Object[0]);
            return new GetQueryResultsStreamResponseParser(this.fetchSize, new GetQueryResultsStreamStaticMetadataParser());
        }
        logger.trace("Using GetQueryResultsStreamResponseParser to parse non plain text results", new Object[0]);
        return new GetQueryResultsStreamResponseParser(this.fetchSize, new GetQueryResultsStreamMetadataParser());
    }

    public ResultRowsParser createS3ResultRowsParser(QueryExecution queryExecution, int numColumns) {
        if (ResultFormatHelper.isPlainTextResult(queryExecution)) {
            if (this.isSplitPlainTextResultsMode()) {
                logger.warn("Legacy mode SplitPlainTextResults is enabled. It is deprecated and its use can lead to incorrect query results", new Object[0]);
                logger.trace("Using AthenaTabSeparatedParser to parse results with {} column(s)", numColumns);
                return new AthenaTabSeparatedParser(numColumns);
            }
            logger.trace("Using LineParser to parse plain text results", new Object[0]);
            return new LineParser();
        }
        logger.trace("Using AthenaCsvParser to parse csv results with {} column(s)", numColumns);
        return new AthenaCsvParser(numColumns);
    }

    MetadataFetcher getS3MetadataFetcher(AthenaAsyncClient athenaClient, S3AsyncClient s3Client, QueryExecution queryMetadata, boolean alwaysValidateAccess) {
        if (ResultFormatHelper.isPlainTextResult(queryMetadata)) {
            MetadataFetcher fetcher;
            if (this.isSplitPlainTextResultsMode()) {
                logger.warn("Legacy mode SplitPlainTextResults is enabled. It is deprecated and its use can lead to incorrect query results", new Object[0]);
                logger.trace("Using S3GetQueryResultsMetadataFetcher to fetch result metadata", new Object[0]);
                fetcher = new S3GetQueryResultsMetadataFetcher(athenaClient, queryMetadata);
            } else {
                logger.trace("Using S3StaticMetadataFetcher to fetch result metadata", new Object[0]);
                fetcher = new S3StaticMetadataFetcher(queryMetadata);
            }
            if (alwaysValidateAccess) {
                fetcher = S3MetadataFetcher.createAccessValidatingS3MetadataFetcher(s3Client, queryMetadata, fetcher);
            }
            return fetcher;
        }
        logger.trace("Using S3MetadataFetcher to fetch result metadata", new Object[0]);
        return new S3MetadataFetcher(s3Client, queryMetadata, true);
    }

    private boolean isSplitPlainTextResultsMode() {
        return this.legacyModes.contains(SPLIT_PLAIN_TEXT_RESULTS);
    }

    @Generated
    public Set<String> getLegacyModes() {
        return this.legacyModes;
    }

    @Generated
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultParserFactory)) {
            return false;
        }
        ResultParserFactory other = (ResultParserFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        Set<String> this$legacyModes = this.getLegacyModes();
        Set<String> other$legacyModes = other.getLegacyModes();
        return !(this$legacyModes == null ? other$legacyModes != null : !((Object)this$legacyModes).equals(other$legacyModes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultParserFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFetchSize();
        Set<String> $legacyModes = this.getLegacyModes();
        result = result * 59 + ($legacyModes == null ? 43 : ((Object)$legacyModes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultParserFactory(legacyModes=" + this.getLegacyModes() + ", fetchSize=" + this.getFetchSize() + ")";
    }
}

