/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing;

import com.amazon.athena.client.results.parsing.ResultRowsParser;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;

public class AthenaCsvParser
implements ResultRowsParser {
    private static final byte QUOTE = 34;
    private static final byte FIELD_SEPARATOR = 44;
    private static final byte ROW_SEPARATOR = 10;
    private final int columnCount;
    private final Queue<byte[]> currentField;
    private int globalIndex;
    private int currentFieldSize;
    private String[] currentRow;
    private int currentFieldIndex;
    private ParserState parserState;
    private int rowCount;

    public AthenaCsvParser(int columnCount) {
        if (columnCount < 1) {
            throw new IllegalArgumentException(String.format("Invalid column count: %d", columnCount));
        }
        this.columnCount = columnCount;
        this.globalIndex = 0;
        this.currentFieldSize = 0;
        this.currentRow = new String[columnCount];
        this.currentFieldIndex = 0;
        this.currentField = new LinkedList<byte[]>();
        this.parserState = ParserState.START_OF_FIELD;
        this.rowCount = 0;
    }

    @Override
    public int parse(ByteBuffer chunk, Consumer<String[]> onRow) throws ParseException {
        int rowCountBefore = this.rowCount;
        if (this.parserState == ParserState.INSIDE_FIELD || this.parserState == ParserState.DETECT_ESCAPE_OR_END_OF_FIELD) {
            chunk.mark();
        }
        while (chunk.hasRemaining()) {
            ++this.globalIndex;
            this.parserState = this.processNext(chunk.get(), chunk, onRow);
        }
        if (this.parserState == ParserState.INSIDE_FIELD) {
            this.storePartialFieldValue(chunk, false);
        }
        return this.rowCount - rowCountBefore;
    }

    @Override
    public int finish(Consumer<String[]> onRow) throws ParseException {
        return 0;
    }

    private ParserState processNext(byte b, ByteBuffer chunk, Consumer<String[]> onRow) throws ParseException {
        switch (this.parserState) {
            case START_OF_FIELD: {
                if (b == 44) {
                    this.parserState = this.handleEmptyField();
                    return this.processNext(b, chunk, onRow);
                }
                if (b == 10 && this.currentFieldIndex == this.columnCount - 1) {
                    return this.handleEndOfRow(onRow);
                }
                if (b == 34) {
                    return this.handleStartOfField(chunk);
                }
                return this.throwParseError("quote or field separator", b);
            }
            case INSIDE_FIELD: {
                if (b == 34) {
                    return this.handleEndOfFieldOrEscapedQuote(chunk);
                }
                return this.parserState;
            }
            case EXPECT_FIELD_SEPARATOR: {
                if (b == 44) {
                    return ParserState.START_OF_FIELD;
                }
                return this.throwParseError("field separator", b);
            }
            case EXPECT_ROW_SEPARATOR: {
                if (b == 10) {
                    return this.handleEndOfRow(onRow);
                }
                return this.throwParseError("row separator", b);
            }
            case DETECT_ESCAPE_OR_END_OF_FIELD: {
                if (b == 34) {
                    return ParserState.INSIDE_FIELD;
                }
                this.parserState = this.handleEndOfField();
                return this.processNext(b, chunk, onRow);
            }
        }
        throw new IllegalStateException();
    }

    private ParserState handleEmptyField() {
        this.currentRow[this.currentFieldIndex] = null;
        ++this.currentFieldIndex;
        if (this.currentFieldIndex == this.columnCount) {
            return ParserState.EXPECT_ROW_SEPARATOR;
        }
        return ParserState.EXPECT_FIELD_SEPARATOR;
    }

    private ParserState handleEndOfRow(Consumer<String[]> onRow) {
        ++this.rowCount;
        onRow.accept(this.currentRow);
        this.currentRow = new String[this.columnCount];
        this.currentFieldIndex = 0;
        return ParserState.START_OF_FIELD;
    }

    private ParserState handleStartOfField(ByteBuffer chunk) {
        chunk.mark();
        return ParserState.INSIDE_FIELD;
    }

    private ParserState handleEndOfField() {
        this.currentRow[this.currentFieldIndex] = this.finalizeFieldValue();
        ++this.currentFieldIndex;
        if (this.currentFieldIndex == this.columnCount) {
            return ParserState.EXPECT_ROW_SEPARATOR;
        }
        return ParserState.EXPECT_FIELD_SEPARATOR;
    }

    private ParserState handleEndOfFieldOrEscapedQuote(ByteBuffer chunk) {
        this.storePartialFieldValue(chunk, true);
        chunk.mark();
        return ParserState.DETECT_ESCAPE_OR_END_OF_FIELD;
    }

    private void storePartialFieldValue(ByteBuffer chunk, boolean skipLastByte) {
        int endPosition = chunk.position();
        chunk.reset();
        int length = endPosition - chunk.position() - (skipLastByte ? 1 : 0);
        byte[] partialValue = new byte[length];
        chunk.get(partialValue);
        if (skipLastByte) {
            chunk.get();
        }
        this.currentField.add(partialValue);
        this.currentFieldSize += partialValue.length;
    }

    private String finalizeFieldValue() {
        byte[] value = new byte[this.currentFieldSize];
        int offset = 0;
        for (byte[] piece : this.currentField) {
            System.arraycopy(piece, 0, value, offset, piece.length);
            offset += piece.length;
        }
        this.currentField.clear();
        this.currentFieldSize = 0;
        return new String(value, StandardCharsets.UTF_8);
    }

    private ParserState throwParseError(String expected, byte actual) throws ParseException {
        String actualStr = actual == 10 ? "newline" : new String(new byte[]{34, actual, 34});
        throw new ParseException(String.format("Expected %s at index %d but got %s", expected, this.globalIndex, actualStr), this.globalIndex);
    }

    private static enum ParserState {
        START_OF_FIELD,
        INSIDE_FIELD,
        DETECT_ESCAPE_OR_END_OF_FIELD,
        EXPECT_FIELD_SEPARATOR,
        EXPECT_ROW_SEPARATOR;

    }
}

