/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing;

import com.amazon.athena.client.results.parsing.LineParser;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.function.Consumer;

public class AthenaTabSeparatedParser
extends LineParser {
    private final int columnCount;

    public AthenaTabSeparatedParser(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public int parse(ByteBuffer chunk, Consumer<String[]> onRow) throws ParseException {
        return super.parse(chunk, row -> onRow.accept(AthenaTabSeparatedParser.splitLine(row[0], this.columnCount)));
    }

    @Override
    public int finish(Consumer<String[]> onRow) throws ParseException {
        return super.finish(row -> onRow.accept(AthenaTabSeparatedParser.splitLine(row[0], this.columnCount)));
    }

    public static String[] splitLine(String line, int columnCount) {
        String[] values = line.split("\t");
        if (values.length == columnCount) {
            return values;
        }
        String[] adjustedRow = new String[columnCount];
        int copyLength = Math.min(values.length, columnCount);
        System.arraycopy(values, 0, adjustedRow, 0, copyLength);
        return adjustedRow;
    }
}

