/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.support.AutoUnwrap;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

class AthenaParameterMetaData
implements ParameterMetaData,
AutoUnwrap {
    private final int parameterCount;

    AthenaParameterMetaData(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    void checkParameterIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.parameterCount) {
            throw new SQLException(String.format("Index %d is out of bounds for a prepared statement with %d parameters", parameterIndex, this.parameterCount));
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return 2;
    }

    @Override
    public boolean isSigned(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return true;
    }

    @Override
    public int getPrecision(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return 0;
    }

    @Override
    public int getScale(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return 0;
    }

    @Override
    public int getParameterType(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return 1111;
    }

    @Override
    public String getParameterTypeName(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return null;
    }

    @Override
    public String getParameterClassName(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return null;
    }

    @Override
    public int getParameterMode(int parameterIndex) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        return 1;
    }
}

