/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.AdfsCredentialsProvider;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AdfsCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> ADFS_RELYING_PARTY = ConnectionParameter.builder().name("AdfsRelyingParty").alias("LoginToRP").defaultValue("urn:amazon:webservices").build();
    public static final ConnectionParameter<Boolean> ADFS_WIA_ENABLED = ConnectionParameter.builder().name("AdfsWiaEnabled").defaultValue(false).valueConverter(AdfsCredentialsProviderFactory::parseWiaEnabledParameter).build();
    private final AdfsCredentialsProvider.Builder credentialsProviderBuilder;

    public AdfsCredentialsProviderFactory() {
        this.credentialsProviderBuilder = AdfsCredentialsProvider.builder();
    }

    AdfsCredentialsProviderFactory(AdfsCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "ADFS";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Optional<String> username = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> password = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        Optional<String> hostName = ConnectionParameters.IDP_HOST_NAME.findValue(parameters);
        Optional<Integer> portNumber = ConnectionParameters.IDP_PORT_NUMBER.findValue(parameters);
        Optional<String> relyingParty = ADFS_RELYING_PARTY.findValue(parameters);
        Optional<Boolean> adfsWiaEnabled = ADFS_WIA_ENABLED.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        ArrayList<String> errors = new ArrayList<String>();
        if (!hostName.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.IDP_HOST_NAME.name(), this.name()));
        }
        if (!portNumber.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.IDP_PORT_NUMBER.name(), this.name()));
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            throw new IllegalArgumentException(errorMessage);
        }
        return this.credentialsProviderBuilder.username(username.orElse(null)).password(password.orElse(null)).hostName(hostName.get()).portNumber((int)portNumber.get()).relyingParty(relyingParty.get()).wiaEnabled(adfsWiaEnabled.get()).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).connectionParameters(parameters).build();
    }

    private static Boolean parseWiaEnabledParameter(String value) {
        if (value != null && (value.equalsIgnoreCase("true") || value.equals("1"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equals("0"))) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Invalid value for AD FS WIA enabled \"%s\" (expected 'true' (any capitalization), 'false' (any capitalization), '0' or '1'", value));
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.IDP_HOST_NAME, ConnectionParameters.IDP_PORT_NUMBER, ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.PASSWORD_PARAMETER, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.USER_PARAMETER, ADFS_RELYING_PARTY, ADFS_WIA_ENABLED);
    }
}

