/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.IdpCredentialsProvider;
import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(OktaCredentialsProvider.class);
    private static final String SESSION_TOKEN_URI_TEMPLATE = "https://%s/api/v1/authn";
    private static final String SAML_URI_TEMPLATE = "https://%s/home/%s/%s?onetimetoken=%s";
    private static final String USERNAME_PASSWORD_ENTITY_TEMPLATE = "{\"username\":\"%s\",\"password\":\"%s\"}";
    private static final Pattern INPUT_TAG_PATTERN = Pattern.compile("<input(.+?)/>", 32);
    private static final Pattern NAME_PATTERN = Pattern.compile("name=\"([^\"]+)\"");
    private static final Pattern VALUE_PATTERN = Pattern.compile("value=\"([^\"]+)\"");
    private static final String OKTA_SMS_FACTOR_TYPE = "sms";
    private static final String OKTA_PUSH_FACTOR_TYPE = "push";
    private static final String OKTA_TOTP_FACTOR_TYPE = "token:software:totp";
    private static final String PROVIDER_OKTA = "OKTA";
    private static final String PROVIDER_GOOGLE = "GOOGLE";
    private static final String OKTA_SESSION_TOKEN = "sessionToken";
    private static final String OKTA_STATE_TOKEN = "stateToken";
    private static final String OKTA_PASS_CODE = "passCode";
    private static final String OKTA_FACTOR_TYPE = "factorType";
    private static final String OKTA_FACTOR_PROVIDER = "provider";
    private static final String OKTA_EMBEDDED_USER_INFO = "_embedded";
    private static final String OKTA_LINKS = "_links";
    private static final String OKTA_VERIFY = "verify";
    private static final String OKTA_HREF = "href";
    private static final String OKTA_SESSION_TOKEN_STATUS = "status";
    private static final String OKTA_SESSION_TOKEN_FACTOR_RESULT = "factorResult";
    private static final String OKTA_SESSION_TOKEN_STATUS_SUCCESS = "SUCCESS";
    private static final String OKTA_SESSION_TOKEN_STATUS_WAITING = "WAITING";
    private static final String OKTA_SESSION_TOKEN_MFA_REQUIRED = "MFA_REQUIRED";
    private static final String OKTA_SESSION_TOKEN_MFA_CHALLENGE = "MFA_CHALLENGE";
    private static final String OKTA_SESSION_TOKEN_MFA_ENROLL = "MFA_ENROLL";
    private static final int OKTA_MFA_WAIT_TIME_SEC = 60;
    private static final int POLL_DELAY_MILLIS = 5000;
    private static final Map<String, Pair<String, String>> MFA_TYPE_TO_FACTOR_AND_PROVIDER = new HashMap<String, Pair<String, String>>();
    private final String username;
    private final String password;
    private final String hostName;
    private final String appId;
    private final String appName;
    private final String mfaType;
    private final Integer mfaWaitTime;
    private final String phoneNumber;
    private final Supplier<CloseableHttpClient> httpClientFactory;
    private final JsonNodeParser jsonParser;
    private final Supplier<String> passcodeSupplier;
    private final InterruptableConsumer<Integer> threadSleeper;

    private OktaCredentialsProvider(String username, String password, String hostName, String appId, String appName, String mfaType, Integer mfaWaitTime, String phoneNumber, String preferredRole, Integer roleSessionDuration, Region region, Supplier<CloseableHttpClient> httpClientFactory, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lakeFormationClientFactory, boolean lakeFormationEnabled, Clock clock, Supplier<String> passcodeSupplier, InterruptableConsumer<Integer> threadSleeper, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lakeFormationClientFactory, null, clock, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        MFA_TYPE_TO_FACTOR_AND_PROVIDER.put("oktaverifywithtotp", (Pair<String, String>)Pair.of((Object)OKTA_TOTP_FACTOR_TYPE, (Object)PROVIDER_OKTA));
        MFA_TYPE_TO_FACTOR_AND_PROVIDER.put("oktaverifywithpush", (Pair<String, String>)Pair.of((Object)OKTA_PUSH_FACTOR_TYPE, (Object)PROVIDER_OKTA));
        MFA_TYPE_TO_FACTOR_AND_PROVIDER.put("smsauthentication", (Pair<String, String>)Pair.of((Object)OKTA_SMS_FACTOR_TYPE, (Object)PROVIDER_OKTA));
        MFA_TYPE_TO_FACTOR_AND_PROVIDER.put("googleauthenticator", (Pair<String, String>)Pair.of((Object)OKTA_TOTP_FACTOR_TYPE, (Object)PROVIDER_GOOGLE));
        this.username = username;
        this.password = password;
        this.hostName = hostName;
        this.appId = appId;
        this.appName = appName;
        this.mfaType = mfaType;
        this.mfaWaitTime = mfaWaitTime == null ? 60 : mfaWaitTime;
        this.phoneNumber = phoneNumber;
        this.httpClientFactory = httpClientFactory == null ? () -> IdpCredentialsProvider.createHttpClient(parameters) : httpClientFactory;
        this.passcodeSupplier = passcodeSupplier == null ? () -> JOptionPane.showInputDialog("Enter passcode to authenticate with Okta:") : passcodeSupplier;
        this.threadSleeper = threadSleeper == null ? Thread::sleep : threadSleeper;
        this.jsonParser = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        HttpPost sessionTokenRequest = this.createSessionTokenRequest();
        String sessionToken = this.fetchSessionToken(sessionTokenRequest);
        logger.info("Obtained session token from Okta", new Object[0]);
        HttpGet get = this.createSamlRequest(sessionToken);
        String samlAssertion = this.fetchSamlAssertion(get);
        logger.info("Obtained SAML assertion from Okta", new Object[0]);
        return samlAssertion;
    }

    private HttpPost createSessionTokenRequest() {
        try {
            URI uri = new URI(String.format(SESSION_TOKEN_URI_TEMPLATE, this.hostName));
            HttpPost post = new HttpPost(uri);
            StringEntity entity = new StringEntity(String.format(USERNAME_PASSWORD_ENTITY_TEMPLATE, this.username, this.password), "UTF-8");
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Accept", "application/json");
            post.setEntity((HttpEntity)entity);
            return post;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct an Okta endpoint from the provided host name (\"%s\"), the URL \"%s\" is invalid", this.hostName, String.format(SESSION_TOKEN_URI_TEMPLATE, this.hostName)), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSessionToken(HttpPost request) {
        logger.debug("Requesting session token from Okta: {}", request.getURI());
        try (CloseableHttpClient httpClient = this.httpClientFactory.get();){
            String status;
            Throwable throwable;
            CloseableHttpResponse response;
            block35: {
                String string;
                block36: {
                    JsonNode responseBodyJson;
                    block33: {
                        String string2;
                        block34: {
                            response = httpClient.execute((HttpUriRequest)request);
                            throwable = null;
                            this.validateHttpResponse(response);
                            String responseString = OktaCredentialsProvider.extractResponseBody(response);
                            responseBodyJson = this.getJsonParser().parse(responseString);
                            status = responseBodyJson.field(OKTA_SESSION_TOKEN_STATUS).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find status in response from Okta"));
                            if (!status.equalsIgnoreCase(OKTA_SESSION_TOKEN_STATUS_SUCCESS)) break block33;
                            String sessionToken = responseBodyJson.field(OKTA_SESSION_TOKEN).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find sessionToken in response from Okta"));
                            if (sessionToken.isEmpty()) {
                                throw new AuthenticationException("Empty sessionToken in the response from Okta");
                            }
                            string2 = sessionToken;
                            if (response == null) return string2;
                            if (throwable == null) break block34;
                            try {
                                response.close();
                                return string2;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return string2;
                            }
                        }
                        response.close();
                        return string2;
                    }
                    if (!status.equalsIgnoreCase(OKTA_SESSION_TOKEN_MFA_REQUIRED)) break block35;
                    this.validateMfaRelatedConnectionParameters();
                    string = this.authenticateEnrolledUserWithSecondFactor(httpClient, responseBodyJson);
                    if (response == null) return string;
                    if (throwable == null) break block36;
                    try {
                        response.close();
                        return string;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return string;
                    }
                }
                response.close();
                return string;
            }
            try {
                try {
                    if (status.equalsIgnoreCase(OKTA_SESSION_TOKEN_MFA_ENROLL)) {
                        throw new AuthenticationException("It appears that a second authentication factor needs to be enrolled with Okta. Please, do that via your Okta account or contact your Okta admin");
                    }
                    throw new AuthenticationException(String.format("Received an unrecognized status, \"%s\", from Okta in response to request for session token", status));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (response == null) throw throwable5;
                if (throwable == null) {
                    response.close();
                    throw throwable5;
                }
                try {
                    response.close();
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throwable.addSuppressed(throwable6);
                    throw throwable5;
                }
            }
        }
        catch (IOException e) {
            throw new AuthenticationException("Unable to obtain the session token from Okta", e);
        }
    }

    private void validateMfaRelatedConnectionParameters() {
        if (this.mfaType == null) {
            throw new IllegalArgumentException("An Okta MFA type must be provided");
        }
        if (this.mfaType.equalsIgnoreCase("smsauthentication") && this.phoneNumber == null) {
            throw new IllegalArgumentException("A phone number must be provided when the Okta MFA type is \"SmsAuthentication\"");
        }
    }

    private String authenticateEnrolledUserWithSecondFactor(CloseableHttpClient httpClient, JsonNode responseBody) {
        URI uri = this.extractSecondFactorVerificationUri(responseBody);
        String correlationId = responseBody.field(OKTA_STATE_TOKEN).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find a state token in response from Okta"));
        if (this.mfaType.equalsIgnoreCase("oktaverifywithpush")) {
            return this.authenticateWithPushNotification(httpClient, uri, correlationId);
        }
        return this.authenticateWithPasscode(httpClient, uri, correlationId);
    }

    private String authenticateWithPasscode(CloseableHttpClient httpClient, URI uri, String correlationId) {
        String passcode;
        HttpPost request;
        JsonNode response;
        String status;
        logger.debug("Authenticating to Okta using one time passcode as a second factor", new Object[0]);
        if (this.mfaType.equalsIgnoreCase("smsauthentication")) {
            this.sendSmsNotification(httpClient, uri, correlationId);
        }
        if ((status = (response = this.sendHttpRequestAndUnpackResponse(httpClient, request = this.createUserPasscodeVerificationRequest(uri, correlationId, passcode = this.obtainPasscodeFromUser()), "Unable to obtain response from Okta for user passcode verification")).field(OKTA_SESSION_TOKEN_STATUS).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find status in response from Okta to passcode verification request"))).equalsIgnoreCase(OKTA_SESSION_TOKEN_STATUS_SUCCESS)) {
            String sessionToken = response.field(OKTA_SESSION_TOKEN).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find session token in response from Okta to passcode verification request"));
            return sessionToken;
        }
        throw new AuthenticationException("Okta user could not be verified");
    }

    private String obtainPasscodeFromUser() {
        String passCode = this.passcodeSupplier.get();
        if (passCode != null) {
            return passCode;
        }
        throw new AuthenticationException("The user cancelled the authentication process");
    }

    private void sendSmsNotification(CloseableHttpClient httpClient, URI uri, String correlationId) {
        HttpPost request = this.createSecondFactorVerificationRequest(uri, correlationId);
        JsonNode response = this.sendHttpRequestAndUnpackResponse(httpClient, request, "Unable to obtain response to Okta request for SMS notification");
        String status = response.field(OKTA_SESSION_TOKEN_STATUS).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find status in response from Okta"));
        if (!status.equalsIgnoreCase(OKTA_SESSION_TOKEN_MFA_CHALLENGE)) {
            throw new AuthenticationException("SMS challenged failed");
        }
    }

    private String authenticateWithPushNotification(CloseableHttpClient httpClient, URI uri, String correlationId) {
        logger.debug("Authenticating to Okta using push notification as a second factor", new Object[0]);
        Instant start = this.clock.instant();
        Instant cutoffTime = start.plusSeconds(this.mfaWaitTime.longValue());
        while (cutoffTime.compareTo(this.clock.instant()) >= 0) {
            HttpPost request = this.createSecondFactorVerificationRequest(uri, correlationId);
            JsonNode response = this.sendHttpRequestAndUnpackResponse(httpClient, request, "Unable to obtain response to Okta Verify request for push notification");
            String status = response.field(OKTA_SESSION_TOKEN_STATUS).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find status in response from Okta"));
            if (status.equalsIgnoreCase(OKTA_SESSION_TOKEN_STATUS_SUCCESS)) {
                return response.field(OKTA_SESSION_TOKEN).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find session token in response from Okta"));
            }
            if (status.equalsIgnoreCase(OKTA_SESSION_TOKEN_MFA_ENROLL)) {
                throw new AuthenticationException("Please enroll a push authentication factor with Okta");
            }
            String authenticationResult = response.field(OKTA_SESSION_TOKEN_FACTOR_RESULT).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find factor result in response from Okta"));
            if (!authenticationResult.equalsIgnoreCase(OKTA_SESSION_TOKEN_STATUS_WAITING)) {
                throw new AuthenticationException("Okta Verify push authentication was rejected");
            }
            try {
                this.threadSleeper.accept(5000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AuthenticationException("Thread was interrupted while polling for the status of Okta Verify push", e);
            }
        }
        logger.warn("Okta Verify push timed out after {} seconds", (int)this.mfaWaitTime);
        throw new AuthenticationException("Polling for the status of Okta Verify push timed out");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode sendHttpRequestAndUnpackResponse(CloseableHttpClient httpClient, HttpPost request, String errorMessage) {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            JsonNode responseBodyJson;
            String responseBody = OktaCredentialsProvider.extractResponseBody(response);
            JsonNode jsonNode = responseBodyJson = this.getJsonParser().parse(responseBody);
            return jsonNode;
        }
        catch (IOException e) {
            throw new AuthenticationException(errorMessage, e);
        }
    }

    private HttpPost createSecondFactorVerificationRequest(URI uri, String correlationId) {
        HttpPost post = new HttpPost(uri);
        post.addHeader("Accept", "application/json");
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.addHeader("Cache-Control", "no-cache");
        StringEntity body = new StringEntity("{\"stateToken\":\"" + correlationId + "\"}", "UTF-8");
        post.setEntity((HttpEntity)body);
        return post;
    }

    private HttpPost createUserPasscodeVerificationRequest(URI uri, String correlationId, String passcode) {
        HttpPost post = new HttpPost(uri);
        post.addHeader("Accept", "application/json");
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.addHeader("Cache-Control", "no-cache");
        StringEntity body = new StringEntity("{\"stateToken\":\"" + correlationId + "\",\"" + OKTA_PASS_CODE + "\":\"" + passcode + "\"}", "UTF-8");
        post.setEntity((HttpEntity)body);
        return post;
    }

    private URI extractSecondFactorVerificationUri(JsonNode responseBody) {
        String chosenFactorType = (String)MFA_TYPE_TO_FACTOR_AND_PROVIDER.get(this.mfaType.toLowerCase()).left();
        String chosenProvider = (String)MFA_TYPE_TO_FACTOR_AND_PROVIDER.get(this.mfaType.toLowerCase()).right();
        JsonNode embeddedField = (JsonNode)responseBody.field(OKTA_EMBEDDED_USER_INFO).orElseThrow(() -> new AuthenticationException(String.format("Failed to find %s field in response from Okta", OKTA_EMBEDDED_USER_INFO)));
        List factorsAllowedByOkta = embeddedField.field("factors").map(JsonNode::asArray).orElseThrow(() -> new AuthenticationException("Failed to find second authentication factors in response from Okta"));
        for (JsonNode factor : factorsAllowedByOkta) {
            String factorType = factor.field(OKTA_FACTOR_TYPE).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find factor type in response from Okta"));
            String provider = factor.field(OKTA_FACTOR_PROVIDER).map(JsonNode::text).orElseThrow(() -> new AuthenticationException("Failed to find provider in response from Okta"));
            if (!factorType.equalsIgnoreCase(chosenFactorType) || !provider.equalsIgnoreCase(chosenProvider)) continue;
            try {
                String uri = ((JsonNode)((JsonNode)((JsonNode)factor.field(OKTA_LINKS).get()).field(OKTA_VERIFY).get()).field(OKTA_HREF).get()).text();
                return new URI(uri);
            }
            catch (NoSuchElementException e) {
                throw new AuthenticationException("Failed to find the second factor verification URL in response from Okta", e);
            }
            catch (URISyntaxException e) {
                throw new AuthenticationException("The second factor verification URL in response from Okta is not a valid URL", e);
            }
        }
        throw new AuthenticationException("Failed to find supported MFA authenticators in response from Okta");
    }

    private HttpGet createSamlRequest(String sessionToken) {
        try {
            URI uri = new URI(String.format(SAML_URI_TEMPLATE, this.hostName, this.appName, this.appId, sessionToken));
            return new HttpGet(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct an Okta endpoint from the provided host name (\"%s\"), app name (\"%s\") and app id (\"%s\"), the URL is invalid", this.hostName, this.appName, this.appId), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSamlAssertion(HttpGet request) {
        logger.debug("Requesting SAML assertion from Okta: {}", this.anonymizeSessionToken(request.getURI()));
        try (CloseableHttpClient httpClient = this.httpClientFactory.get();){
            Throwable throwable;
            CloseableHttpResponse response;
            block25: {
                String string;
                block26: {
                    response = httpClient.execute((HttpUriRequest)request);
                    throwable = null;
                    this.validateHttpResponse(response);
                    String responseString = OktaCredentialsProvider.extractResponseBody(response);
                    Optional<String> samlResponse = this.getSamlResponseFromHtml(responseString);
                    if (!samlResponse.isPresent()) break block25;
                    string = samlResponse.get();
                    if (response == null) return string;
                    if (throwable == null) break block26;
                    try {
                        response.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                response.close();
                return string;
            }
            try {
                try {
                    throw new AuthenticationException("Unable to extract the SAMLResponse field from the response body");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (response == null) throw throwable4;
                if (throwable == null) {
                    response.close();
                    throw throwable4;
                }
                try {
                    response.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new AuthenticationException("Unable to obtain the SAML assertion from Okta", e);
        }
    }

    private String anonymizeSessionToken(URI uri) {
        return uri.toASCIIString().replaceFirst("(?<=onetimetoken=).+?(?=\\&|$)", "*******");
    }

    private void validateHttpResponse(CloseableHttpResponse response) {
        if (response.getStatusLine().getStatusCode() != 200) {
            String content = OktaCredentialsProvider.extractResponseBody(response);
            JsonNode entityJson = this.getJsonParser().parse(content);
            String errorCauses = entityJson.field("errorCauses").map(JsonNode::text).orElse("");
            String errorCode = entityJson.field("errorCode").map(JsonNode::text).orElse("");
            String errorId = entityJson.field("errorId").map(JsonNode::text).orElse("");
            String errorSummary = entityJson.field("errorSummary").map(JsonNode::text).orElse("");
            if (!StringUtils.isEmpty((CharSequence)errorCauses)) {
                throw new AuthenticationException(errorCode + " -- " + errorSummary + " -- " + errorId + "-- " + errorCauses);
            }
            throw new AuthenticationException(errorCode + " -- " + errorSummary + " -- " + errorId);
        }
    }

    private static String extractResponseBody(CloseableHttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new AuthenticationException("An error occurred while processing the response from Okta", e);
        }
    }

    private Optional<String> getSamlResponseFromHtml(String body) {
        Matcher inputTagMatcher = INPUT_TAG_PATTERN.matcher(body);
        while (inputTagMatcher.find()) {
            String nameValue;
            String tag = inputTagMatcher.group(0);
            Matcher nameMatcher = NAME_PATTERN.matcher(tag);
            Matcher valueMatcher = VALUE_PATTERN.matcher(tag);
            if (!nameMatcher.find() || !(nameValue = nameMatcher.group(1)).equals("SAMLResponse") || !valueMatcher.find()) continue;
            return Optional.of(this.decodeHtmlCharacterReferences(valueMatcher.group(1)));
        }
        return Optional.empty();
    }

    private JsonNodeParser getJsonParser() {
        return this.jsonParser == null ? JsonNodeParser.create() : this.jsonParser;
    }

    public static class Builder {
        private String username;
        private String password;
        private String hostName;
        private String appId;
        private String appName;
        private String mfaType;
        private Integer mfaWaitTime;
        private String mfaPhoneNumber;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Region region;
        private boolean lakeFormationEnabled;
        private Supplier<CloseableHttpClient> httpClientFactory;
        private AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lakeFormationClientFactory;
        private Clock clock;
        private Integer pollDelay;
        private Supplier<String> passcodeSupplier;
        private InterruptableConsumer<Integer> threadSleeper;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder mfaType(String mfaType) {
            this.mfaType = mfaType;
            return this;
        }

        public Builder mfaWaitTime(Integer mfaWaitTime) {
            this.mfaWaitTime = mfaWaitTime;
            return this;
        }

        public Builder mfaPhoneNumber(String mfaPhoneNumber) {
            this.mfaPhoneNumber = mfaPhoneNumber;
            return this;
        }

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        Builder httpClientFactory(Supplier<CloseableHttpClient> httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory) {
            this.assumeRoleWithSamlRequestFactory = assumeRoleWithSamlRequestFactory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory) {
            this.assumeDecoratedRoleWithSamlRequestFactory = assumeDecoratedRoleWithSamlRequestFactory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder stsClientFactory) {
            this.stsClientFactory = stsClientFactory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder lakeFormationClientFactory) {
            this.lakeFormationClientFactory = lakeFormationClientFactory;
            return this;
        }

        Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        Builder passcodeSupplier(Supplier<String> passcodeSupplier) {
            this.passcodeSupplier = passcodeSupplier;
            return this;
        }

        Builder threadSleeper(InterruptableConsumer<Integer> threadSleeper) {
            this.threadSleeper = threadSleeper;
            return this;
        }

        public OktaCredentialsProvider build() {
            return new OktaCredentialsProvider(this.username, this.password, this.hostName, this.appId, this.appName, this.mfaType, this.mfaWaitTime, this.mfaPhoneNumber, this.preferredRole, this.roleSessionDuration, this.region, this.httpClientFactory, this.assumeRoleWithSamlRequestFactory, this.stsClientFactory, this.assumeDecoratedRoleWithSamlRequestFactory, this.lakeFormationClientFactory, this.lakeFormationEnabled, this.clock, this.passcodeSupplier, this.threadSleeper, this.parameters);
        }
    }

    @FunctionalInterface
    static interface InterruptableConsumer<T> {
        public void accept(T var1) throws InterruptedException;
    }
}

