/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneIamCredentialsProvider;
import com.amazon.athena.jdbc.authentication.datazone.utils.DataZoneEndpointUtils;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.DataZoneClientBuilder;

public class DataZoneIamCredentialsProviderFactory
extends DataZoneCredentialsProviderFactory
implements CredentialsProviderFactory {
    private static final List<ConnectionParameter<?>> REQUIRED_PARAMETERS = Arrays.asList(DATAZONE_DOMAIN_ID_PARAMETER, DATAZONE_ENVIRONMENT_ID_PARAMETER, DATAZONE_DOMAIN_REGION_PARAMETER);
    private final DataZoneClientBuilder dataZoneClientBuilder;

    public DataZoneIamCredentialsProviderFactory() {
        this.dataZoneClientBuilder = DataZoneClient.builder();
    }

    DataZoneIamCredentialsProviderFactory(DataZoneClientBuilder dataZoneClientBuilder) {
        this.dataZoneClientBuilder = dataZoneClientBuilder;
    }

    @Override
    public String name() {
        return "DataZoneIam";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        this.validateParameters(parameters, REQUIRED_PARAMETERS, this.name());
        String domainId = (String)DATAZONE_DOMAIN_ID_PARAMETER.findValue(parameters).get();
        String environmentId = (String)DATAZONE_ENVIRONMENT_ID_PARAMETER.findValue(parameters).get();
        String domainRegion = (String)DATAZONE_DOMAIN_REGION_PARAMETER.findValue(parameters).get();
        Optional datazoneEndpoint = DATAZONE_ENDPOINT_OVERRIDE_PARAMETER.findValue(parameters);
        Optional<String> user = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> password = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        DefaultCredentialsProvider credentialsProvider = user.isPresent() && password.isPresent() ? StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)user.get(), (String)password.get())) : DefaultCredentialsProvider.create();
        String dataZoneClientEndpoint = datazoneEndpoint.orElseGet(() -> DataZoneEndpointUtils.getDataZoneEndpoint(domainRegion));
        DataZoneClient dataZoneClient = (DataZoneClient)((DataZoneClientBuilder)((DataZoneClientBuilder)((DataZoneClientBuilder)this.dataZoneClientBuilder.credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.of((String)domainRegion))).endpointOverride(URI.create(dataZoneClientEndpoint))).build();
        return new DataZoneIamCredentialsProvider(domainId, environmentId, dataZoneClient);
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(DATAZONE_DOMAIN_ID_PARAMETER, DATAZONE_ENVIRONMENT_ID_PARAMETER, DATAZONE_DOMAIN_REGION_PARAMETER, DATAZONE_ENDPOINT_OVERRIDE_PARAMETER, ConnectionParameters.USER_PARAMETER, ConnectionParameters.PASSWORD_PARAMETER);
    }

    @Override
    protected void validateParameters(Map<ConnectionParameter<?>, String> inputParameters, List<ConnectionParameter<?>> requiredParameters, String credentialsProviderName) {
        super.validateParameters(inputParameters, requiredParameters, credentialsProviderName);
        boolean userPresent = ConnectionParameters.USER_PARAMETER.findValue(inputParameters).isPresent();
        boolean passwordPresent = ConnectionParameters.PASSWORD_PARAMETER.findValue(inputParameters).isPresent();
        if (userPresent && !passwordPresent) {
            throw new IllegalArgumentException("User parameter provided without Password parameter");
        }
        if (!userPresent && passwordPresent) {
            throw new IllegalArgumentException("Password parameter provided without User parameter");
        }
    }
}

