/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone.httpserver;

import com.amazon.athena.jdbc.authentication.datazone.httpserver.InvalidHttpRequestHandler;
import com.amazon.athena.jdbc.authentication.datazone.httpserver.ValidHttpRequestHandler;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RequestHandler
implements HttpRequestHandler {
    private static final AthenaLogger logger = AthenaLogger.of(RequestHandler.class);
    private static final String SUPPORTED_METHOD = "GET";
    private final Function<List<NameValuePair>, List<NameValuePair>> requestProcessLogic;
    private final HttpRequestHandler invalidRequestHandler;
    private final HttpRequestHandler validRequestHandler;
    private List<NameValuePair> result;

    public RequestHandler(Function<List<NameValuePair>, List<NameValuePair>> requestProcessLogic, ValidHttpRequestHandler validRequestHandler, InvalidHttpRequestHandler invalidRequestHandler) {
        this.requestProcessLogic = requestProcessLogic;
        this.validRequestHandler = validRequestHandler;
        this.invalidRequestHandler = invalidRequestHandler;
    }

    private void logHeaders(HttpRequest request) {
        Header[] headers;
        for (Header h : headers = request.getAllHeaders()) {
            logger.trace("Received header {} with value {}", h.getName(), h.getValue());
        }
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.logHeaders(request);
        String query = RequestHandler.extractQuery(request.toString());
        if (this.isRequestValid(request)) {
            this.result = this.requestProcessLogic.apply(URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8));
            this.validRequestHandler.handle(request, response, context);
        } else {
            this.invalidRequestHandler.handle(request, response, context);
        }
    }

    public List<NameValuePair> getResult() {
        return this.result;
    }

    private static String extractQuery(String target) {
        int spaceIndex;
        int queryIndex = target.indexOf(63);
        if (queryIndex != -1) {
            target = target.substring(queryIndex + 1);
        }
        if ((spaceIndex = target.indexOf(32)) != -1) {
            return target.substring(0, spaceIndex + 1);
        }
        return "";
    }

    private boolean isRequestValid(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        logger.info("Validating request URI {} and method {}", requestLine.getUri(), requestLine.getMethod());
        return requestLine.getMethod().equalsIgnoreCase(SUPPORTED_METHOD);
    }
}

