/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.http;

import com.amazon.athena.jdbc.authentication.http.HttpClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public class ProxyAwareHttpClientFactory
implements HttpClientFactory {
    private static final int SOCKET_TIMEOUT_MS = 60000;
    private static final int CONNECTION_TIMEOUT_MS = 60000;
    private final ProxyConfiguration proxyConfiguration;
    private final Supplier<RequestConfig.Builder> requestConfigBuilderFactory;
    private final Supplier<CredentialsProvider> credentialsProviderFactory;

    public ProxyAwareHttpClientFactory(ProxyConfiguration proxyConfiguration) {
        this(proxyConfiguration, RequestConfig::custom, BasicCredentialsProvider::new);
    }

    protected ProxyAwareHttpClientFactory(ProxyConfiguration proxyConfiguration, Supplier<RequestConfig.Builder> requestConfigBuilderFactory, Supplier<CredentialsProvider> credentialsProviderFactory) {
        this.proxyConfiguration = proxyConfiguration;
        this.requestConfigBuilderFactory = requestConfigBuilderFactory;
        this.credentialsProviderFactory = credentialsProviderFactory;
    }

    @Override
    public CloseableHttpClient createClient() throws URISyntaxException {
        RequestConfig.Builder rc = this.requestConfigBuilderFactory.get().setSocketTimeout(60000).setConnectTimeout(60000).setExpectContinueEnabled(false).setCookieSpec("standard");
        HttpClientBuilder builder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).useSystemProperties();
        if (this.proxyConfiguration != null) {
            String proxyHost = this.proxyConfiguration.host();
            int proxyPort = this.proxyConfiguration.port();
            if (proxyHost != null && !proxyHost.isEmpty()) {
                URI proxyUri = new URI(this.proxyConfiguration.scheme() + "://" + proxyHost + ":" + proxyPort);
                rc.setProxy(new HttpHost(proxyUri.getHost(), proxyPort, proxyUri.getScheme()));
                String proxyUsername = this.proxyConfiguration.username();
                String proxyPassword = this.proxyConfiguration.password();
                if (proxyUsername != null && !proxyUsername.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                    CredentialsProvider credentialsProvider = this.credentialsProviderFactory.get();
                    credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                    builder.setDefaultCredentialsProvider(credentialsProvider);
                }
            }
        }
        builder.setDefaultRequestConfig(rc.build());
        return builder.build();
    }
}

