/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.oidc;

import com.amazon.athena.jdbc.authentication.http.BrowserAuthenticationServer;
import com.amazon.athena.jdbc.authentication.http.HttpClientFactory;
import com.amazon.athena.jdbc.authentication.oidc.JwtTokenValidator;
import com.amazon.athena.jdbc.authentication.oidc.OpenIdConnectWellKnownConfigurationService;
import com.amazon.athena.jdbc.cache.JwtTokenCacheEntry;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.NameValuePair;

abstract class OpenIdConnectTemplate {
    private static final AthenaLogger logger = AthenaLogger.of(OpenIdConnectTemplate.class);
    private static final String REDIRECT_URI_PATTERN = "http://localhost:%d/athena";
    private final int localServerPort;
    private final int localServerTimeout;
    private final Desktop desktop;
    private final BrowserAuthenticationServer server;
    protected final String scope;
    protected final String redirectUri;
    protected final JwtTokenValidator jwtTokenValidator;
    protected final HttpClientFactory httpClientFactory;
    protected final OpenIdConnectWellKnownConfigurationService openIdConnectWellKnownConfigurationService;

    public OpenIdConnectTemplate(String scope, int localServerPort, int localServerTimeout, Desktop desktop, BrowserAuthenticationServer server, HttpClientFactory httpClientFactory, OpenIdConnectWellKnownConfigurationService openIdConnectWellKnownConfigurationService, JwtTokenValidator jwtTokenValidator) {
        this.localServerPort = localServerPort;
        this.localServerTimeout = localServerTimeout;
        this.desktop = desktop;
        this.server = server;
        this.scope = scope;
        this.openIdConnectWellKnownConfigurationService = openIdConnectWellKnownConfigurationService;
        this.httpClientFactory = httpClientFactory;
        this.jwtTokenValidator = jwtTokenValidator;
        this.redirectUri = String.format(REDIRECT_URI_PATTERN, localServerPort);
    }

    public final JwtTokenCacheEntry fetchToken() {
        try {
            logger.info("Starting local server to fetch authorization code from external identity provider", new Object[0]);
            Future<List<NameValuePair>> responseFuture = this.server.listenForResponse();
            String authUrl = this.buildAuthorizationEndpointUrl();
            URI uri = new URI(authUrl);
            this.openBrowser(uri);
            List<NameValuePair> response = responseFuture.get(this.localServerTimeout, TimeUnit.SECONDS);
            JwtTokenCacheEntry jwtTokenCacheEntry = this.processAuthResponse(response);
            return jwtTokenCacheEntry;
        }
        catch (TimeoutException ex) {
            throw new AuthenticationException("Authentication timed out: " + ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new AuthenticationException("Authentication interrupted: " + ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            throw new AuthenticationException("Authentication failed: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new AuthenticationException("Unexpected error: " + ex.getMessage(), ex);
        }
        finally {
            this.server.shutdownServer();
        }
    }

    public abstract JwtTokenCacheEntry refreshToken(String var1);

    protected abstract String buildAuthorizationEndpointUrl();

    protected abstract JwtTokenCacheEntry processAuthResponse(List<NameValuePair> var1);

    private void openBrowser(URI url) {
        try {
            this.desktop.browse(url);
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.getMessage());
        }
    }
}

