/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.cache;

import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.CacheEntry;
import com.amazon.athena.logging.AthenaLogger;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DriverCache<T extends CacheEntry>
implements Cache<T> {
    private static final AthenaLogger logger = AthenaLogger.of(DriverCache.class);
    private final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();

    @Override
    public void store(String key, T entry) {
        logger.trace("Storing cache entry of type {}.", entry.getClass().getSimpleName());
        this.cache.put(key, entry);
    }

    @Override
    public Optional get(String key) {
        T entry = this.cache.get(key);
        if (entry == null) {
            logger.trace("No entry found for key", new Object[0]);
            return Optional.empty();
        }
        logger.trace("Retrieved cache entry of type {}", entry.getClass().getSimpleName());
        return Optional.of(entry);
    }

    @Override
    public void remove(String key) {
        logger.trace("Removing cache entry", new Object[0]);
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        logger.trace("Clearing all cache entries", new Object[0]);
        this.cache.clear();
    }
}

