/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class InsertFunction
extends JdbcFunction {
    InsertFunction() {
        super("INSERT", "CONCAT", JdbcFunction.FunctionCategory.STRING, 4, 4);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<Token> rawSource = rawArgs.get(0);
        List<Token> rawInsertPosition = rawArgs.get(1);
        List<Token> rawDeletionCount = rawArgs.get(2);
        List<Token> replacement = rawArgs.get(3);
        LinkedList<Token> prefix = new LinkedList<Token>();
        prefix.add(Token.sql("SUBSTRING("));
        prefix.addAll(rawSource);
        prefix.add(Token.sql(","));
        prefix.add(Token.space());
        prefix.add(Token.sql("1"));
        prefix.add(Token.sql(","));
        prefix.addAll(this.ensureHasWhitespacePrefix(rawInsertPosition));
        if (!this.hasWhitespaceSuffix(rawInsertPosition)) {
            prefix.add(Token.space());
        }
        prefix.add(Token.sql("-"));
        prefix.add(Token.space());
        prefix.add(Token.sql("1"));
        prefix.add(Token.sql(")"));
        LinkedList<Token> suffix = new LinkedList<Token>();
        suffix.add(Token.space());
        suffix.add(Token.sql("SUBSTRING("));
        suffix.addAll(rawSource);
        suffix.add(Token.sql(","));
        suffix.addAll(this.ensureHasWhitespacePrefix(rawInsertPosition));
        if (!this.hasWhitespaceSuffix(rawInsertPosition)) {
            suffix.add(Token.space());
        }
        suffix.add(Token.sql("+"));
        suffix.addAll(this.ensureHasWhitespacePrefix(rawDeletionCount));
        suffix.add(Token.sql(")"));
        return Arrays.asList(prefix, this.ensureHasWhitespacePrefix(replacement), suffix);
    }
}

