/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athenastreaming;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClientBuilder;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingServiceClientConfiguration;
import software.amazon.awssdk.services.athenastreaming.DefaultAthenaStreamingAsyncClientBuilder;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamRequest;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamResponse;

@SdkPublicApi
@ThreadSafe
public interface AthenaStreamingAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "athena";
    public static final String SERVICE_METADATA_ID = "athenastreaming";

    default public <ReturnT> CompletableFuture<ReturnT> getQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest, AsyncResponseTransformer<GetQueryResultsStreamResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getQueryResultsStream(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest, AsyncResponseTransformer<GetQueryResultsStreamResponse, ReturnT> asyncResponseTransformer) {
        return this.getQueryResultsStream((GetQueryResultsStreamRequest)((Object)((GetQueryResultsStreamRequest.Builder)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetQueryResultsStreamResponse> getQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest, Path destinationPath) {
        return this.getQueryResultsStream(getQueryResultsStreamRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetQueryResultsStreamResponse> getQueryResultsStream(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest, Path destinationPath) {
        return this.getQueryResultsStream((GetQueryResultsStreamRequest)((Object)((GetQueryResultsStreamRequest.Builder)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest)).build()), destinationPath);
    }

    default public AthenaStreamingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static AthenaStreamingAsyncClient create() {
        return (AthenaStreamingAsyncClient)AthenaStreamingAsyncClient.builder().build();
    }

    public static AthenaStreamingAsyncClientBuilder builder() {
        return new DefaultAthenaStreamingAsyncClientBuilder();
    }
}

