/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransactionStatusFilter {
    ALL("ALL"),
    COMPLETED("COMPLETED"),
    ACTIVE("ACTIVE"),
    COMMITTED("COMMITTED"),
    ABORTED("ABORTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransactionStatusFilter> VALUE_MAP;
    private final String value;

    private TransactionStatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransactionStatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransactionStatusFilter> knownValues() {
        EnumSet<TransactionStatusFilter> knownValues = EnumSet.allOf(TransactionStatusFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransactionStatusFilter.class, TransactionStatusFilter::toString);
    }
}

