/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilter;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;

public class ListDataCellsFilterIterable
implements SdkIterable<ListDataCellsFilterResponse> {
    private final LakeFormationClient client;
    private final ListDataCellsFilterRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataCellsFilterIterable(LakeFormationClient client, ListDataCellsFilterRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataCellsFilterResponseFetcher();
    }

    public Iterator<ListDataCellsFilterResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataCellsFilter> dataCellsFilters() {
        Function<ListDataCellsFilterResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataCellsFilters() != null) {
                return response.dataCellsFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataCellsFilterResponseFetcher
    implements SyncPageFetcher<ListDataCellsFilterResponse> {
        private ListDataCellsFilterResponseFetcher() {
        }

        public boolean hasNextPage(ListDataCellsFilterResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataCellsFilterResponse nextPage(ListDataCellsFilterResponse previousPage) {
            if (previousPage == null) {
                return ListDataCellsFilterIterable.this.client.listDataCellsFilter(ListDataCellsFilterIterable.this.firstRequest);
            }
            return ListDataCellsFilterIterable.this.client.listDataCellsFilter((ListDataCellsFilterRequest)((Object)ListDataCellsFilterIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

