/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.logging.AthenaLogger;
import java.util.Collections;
import java.util.Optional;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.StatementType;

public class ResultFormatHelper {
    private static final AthenaLogger logger = AthenaLogger.of(ResultFormatHelper.class);
    private static final ColumnInfo PLAIN_TEXT_COLUMN = (ColumnInfo)ColumnInfo.builder().catalogName("hive").name("_col0").label("_col0").type("varchar").precision(65535).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build();
    public static final ResultSetMetadata PLAIN_TEXT_RESULT_SET_METADATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(Collections.singletonList(PLAIN_TEXT_COLUMN)).build();

    static boolean isPlainTextResult(QueryExecution lastQueryExecution) {
        boolean isPlainTextResult = Optional.ofNullable(lastQueryExecution.resultConfiguration()).map(ResultConfiguration::outputLocation).map(outputLocation -> outputLocation.endsWith(".txt")).orElse(ResultFormatHelper.isPlainTextStatementOrSubstatementType(lastQueryExecution));
        logger.debug("Query execution {} results file is of type {}", lastQueryExecution.queryExecutionId(), isPlainTextResult ? "plain text" : "CSV");
        return isPlainTextResult;
    }

    private static boolean isPlainTextStatementOrSubstatementType(QueryExecution queryExecution) {
        return queryExecution.statementType() == StatementType.UTILITY || queryExecution.statementType() == StatementType.DDL || "EXPLAIN".equalsIgnoreCase(queryExecution.substatementType());
    }

    public static ResultPage fixPlainTextMetadata(QueryExecution queryMetadata, ResultPage resultPage) {
        if (ResultFormatHelper.isPlainTextResult(queryMetadata) && resultPage.resultSetMetadata().columnInfo().size() > 1) {
            ResultPage updatedResultPage = resultPage.copyWithResultSetMetadata(PLAIN_TEXT_RESULT_SET_METADATA);
            logger.debug("Query execution {} result set metadata is updated to a single column to make it consistent with the result set produced by Athena", queryMetadata.queryExecutionId());
            return updatedResultPage;
        }
        return resultPage;
    }
}

