/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.jdbc.AthenaQueryExecution;
import com.amazon.athena.jdbc.AthenaStatementBase;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.support.SubscriberIterator;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import software.amazon.awssdk.services.athena.model.StatementType;

public class AthenaResultSet
extends IteratorResultSetBase<String[]>
implements AthenaQueryExecution {
    private final AthenaStatementBase statement;
    private final AsyncQueryResults queryResults;

    AthenaResultSet(AthenaStatementBase statement, AsyncQueryResults queryResults, int maxRows, int maxFieldSize, int fetchSize) {
        super(queryResults.resultSetMetadata(), maxRows, maxFieldSize, fetchSize);
        this.statement = statement;
        this.queryResults = queryResults;
    }

    int updateCount() {
        if (this.hasUpdateCount()) {
            long count = this.queryResults.updateCount();
            if (count > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)count;
        }
        return -1;
    }

    boolean hasUpdateCount() {
        return this.queryResults.queryExecution().statementType() == StatementType.DDL || this.queryResults.queryExecution().statementType() == StatementType.DML && this.queryResults.updateCount() > 0L;
    }

    @Override
    protected Iterator<String[]> iterator() {
        SubscriberIterator subscriberIterator = new SubscriberIterator(this.fetchSize());
        this.queryResults.subscribe(subscriberIterator);
        return subscriberIterator;
    }

    @Override
    protected String stringValue(String[] row, int columnIndex) {
        return row[columnIndex - 1];
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.statement.resultSetClosed(this);
    }

    @Override
    public String getQueryExecutionId() throws SQLException {
        return this.queryResults.queryExecution().queryExecutionId();
    }
}

