/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.logging.AthenaLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class CredentialsProviderRegistry {
    private static final AthenaLogger logger = AthenaLogger.of(CredentialsProviderRegistry.class);
    private final Map<String, CredentialsProviderFactory> credentialsProviderFactories;
    private final Map<String, String> credentialsProviderNames = new HashMap<String, String>();

    public CredentialsProviderRegistry() {
        this.credentialsProviderFactories = new HashMap<String, CredentialsProviderFactory>();
    }

    public void register(CredentialsProviderFactory factory) {
        String lowerCaseName = factory.name().toLowerCase();
        if (this.credentialsProviderNames.containsKey(lowerCaseName)) {
            logger.warn("Replacing credentials provider factory for credentials provider \"{}\"", factory.name());
        }
        this.credentialsProviderNames.put(lowerCaseName, factory.name());
        this.credentialsProviderFactories.put(factory.name(), factory);
    }

    public Optional<String> normalizeName(String name) {
        return Optional.ofNullable(this.credentialsProviderNames.get(name.toLowerCase()));
    }

    public Optional<AwsCredentialsProvider> create(String name, Map<ConnectionParameter<?>, String> parameters) {
        return Optional.ofNullable(this.credentialsProviderFactories.get(name)).map(factory -> factory.create(parameters));
    }
}

