/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class CustomCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final String CREDENTIALS_PROVIDER_NAME = "Custom";

    @Override
    public String name() {
        return CREDENTIALS_PROVIDER_NAME;
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        String className = ConnectionParameters.CREDENTIALS_PROVIDER_PARAMETER.findValue(parameters).orElseThrow(() -> new IllegalArgumentException("Credentials provider is missing"));
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (AwsCredentialsProvider.class.isAssignableFrom(clazz)) {
                String[] credProvArgs = ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.findValue(parameters).orElseGet(() -> new String[0]);
                return this.instantiateCredentialsProvider(clazz, credProvArgs);
            }
            throw new IllegalArgumentException(String.format("Could not instantiate custom credentials provider \"%s\" because it does not implement %s", clazz.getName(), AwsCredentialsProvider.class.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Credentials provider \"%s\" not found", className), e);
        }
    }

    private AwsCredentialsProvider instantiateCredentialsProvider(Class clazz, String[] args) {
        try {
            Object[] argsClasses = new Class[args.length];
            Arrays.fill(argsClasses, String.class);
            return (AwsCredentialsProvider)clazz.getConstructor((Class<?>[])argsClasses).newInstance(args);
        }
        catch (NoSuchMethodException e) {
            if (args.length > 0) {
                throw new IllegalArgumentException(String.format("Could not instantiate custom credentials provider \"%s\" because it does not have a constructor taking the same number of arguments as in %s (%d)", clazz.getName(), ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.name(), args.length), e);
            }
            throw new IllegalArgumentException(String.format("Could not instantiate custom credentials provider \"%s\" because it does not have a no-arguments constructor", clazz.getName()), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not instantiate custom credentials provider \"%s\": %s", clazz.getName(), e.getMessage()), e);
        }
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.CREDENTIALS_PROVIDER_PARAMETER);
    }
}

