/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.TrustedIdentityPropagationAuthenticationWorkflow;
import com.amazon.athena.logging.AthenaLogger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.model.Credentials;

public class JwtTrustedIdentityPropagationCredentialsProvider
implements AwsCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(JwtTrustedIdentityPropagationCredentialsProvider.class);
    private static final Duration EXPIRATION_THRESHOLD_SECS = Duration.ofSeconds(180L);
    private final Clock clock;
    private final String webIdentityToken;
    private final TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow;
    private Credentials credentials;

    JwtTrustedIdentityPropagationCredentialsProvider(String webIdentityToken, TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow) {
        this(webIdentityToken, trustedIdentityPropagationAuthenticationWorkflow, Clock.systemDefaultZone());
    }

    JwtTrustedIdentityPropagationCredentialsProvider(String webIdentityToken, TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow, Clock clock) {
        this.webIdentityToken = webIdentityToken;
        this.trustedIdentityPropagationAuthenticationWorkflow = trustedIdentityPropagationAuthenticationWorkflow;
        this.clock = clock;
    }

    @Override
    public AwsCredentials resolveCredentials() {
        boolean needsUpdate;
        Instant expirationTime = this.clock.instant().plusSeconds(EXPIRATION_THRESHOLD_SECS.getSeconds());
        boolean bl = needsUpdate = this.credentials == null || this.credentials.expiration().compareTo(expirationTime) < 0;
        if (needsUpdate) {
            this.credentials = this.trustedIdentityPropagationAuthenticationWorkflow.obtainCredentials(this.webIdentityToken);
        }
        return AwsSessionCredentials.create(this.credentials.accessKeyId(), this.credentials.secretAccessKey(), this.credentials.sessionToken());
    }
}

