/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class StaticCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final String CREDENTIALS_PROVIDER_NAME = "Static";
    public static final ConnectionParameter<String> SESSION_TOKEN_PARAMETER = ConnectionParameter.builder().name("SessionToken").build();

    @Override
    public String name() {
        return CREDENTIALS_PROVIDER_NAME;
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Optional<String> accessKeyId = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> secretAccessKey = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        Optional<String> sessionToken = SESSION_TOKEN_PARAMETER.findValue(parameters);
        if (accessKeyId.isPresent() && secretAccessKey.isPresent()) {
            return sessionToken.map(token -> StaticCredentialsProvider.create(AwsSessionCredentials.create((String)accessKeyId.get(), (String)secretAccessKey.get(), token))).orElseGet(() -> StaticCredentialsProvider.create(AwsBasicCredentials.create((String)accessKeyId.get(), (String)secretAccessKey.get())));
        }
        throw new IllegalArgumentException("Both an access key ID and a secret access key must be provided for a static credentials provider");
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.PASSWORD_PARAMETER, ConnectionParameters.USER_PARAMETER, SESSION_TOKEN_PARAMETER);
    }
}

