/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone.helpers;

import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsResponse;

public class DataZoneHelper {
    private static final AthenaLogger logger = AthenaLogger.of(DataZoneHelper.class);
    private final String domainId;
    private final String environmentId;
    private final String region;
    private final String endpoint;
    private final HttpClient httpClient;
    private final Function<AwsCredentialsProvider, DataZoneClient> dataZoneClientFactory;
    private final JsonNodeParser jsonNodeParser;

    public DataZoneHelper(String domainId, String environmentId, String region, String endpoint, HttpClient httpClient, Function<AwsCredentialsProvider, DataZoneClient> dataZoneClientFactory) {
        this.domainId = domainId;
        this.environmentId = environmentId;
        this.region = region;
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.dataZoneClientFactory = dataZoneClientFactory;
        this.jsonNodeParser = JsonNodeParser.create();
    }

    public AwsSessionCredentials getEnvironmentCredentials(String accessToken) {
        AwsSessionCredentials derCredentials = this.getAssumedDomainExecutionRole(accessToken);
        StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create(derCredentials);
        GetEnvironmentCredentialsRequest getEnvironmentCredentialsRequest = (GetEnvironmentCredentialsRequest)GetEnvironmentCredentialsRequest.builder().domainIdentifier(this.domainId).environmentIdentifier(this.environmentId).build();
        logger.info(String.format("Retrieving DataZone Environment Credentials for domain: %s, environment: %s", this.domainId, this.environmentId), new Object[0]);
        try (DataZoneClient dataZoneClient = this.dataZoneClientFactory.apply(staticCredentialsProvider);){
            GetEnvironmentCredentialsResponse getEnvironmentCredentialsResponse = dataZoneClient.getEnvironmentCredentials(getEnvironmentCredentialsRequest);
            AwsSessionCredentials awsSessionCredentials = AwsSessionCredentials.builder().accessKeyId(getEnvironmentCredentialsResponse.accessKeyId()).secretAccessKey(getEnvironmentCredentialsResponse.secretAccessKey()).sessionToken(getEnvironmentCredentialsResponse.sessionToken()).expirationTime(getEnvironmentCredentialsResponse.expiration()).build();
            return awsSessionCredentials;
        }
    }

    private AwsSessionCredentials getAssumedDomainExecutionRole(String accessToken) {
        logger.trace("Retrieving DataZone Domain Execution Role Credentials...", new Object[0]);
        String responseString = this.callRedeemAccessTokenWithHttp(accessToken);
        logger.trace("Successfully Retrieved Domain Execution Role Credentials from Amazon DataZone", new Object[0]);
        return this.parseCredentialsFromResponse(responseString);
    }

    private String callRedeemAccessTokenWithHttp(String accessToken) {
        String payload = String.format("{\"domainId\":\"%s\",\"accessToken\":\"%s\"}", this.domainId, accessToken);
        HttpPost httpPost = this.createHttpPostFromPayload(payload);
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute(httpPost);
        }
        catch (IOException e) {
            logger.debug("Failed to call RedeemAccessToken", new Object[0]);
            throw new AuthenticationException(e.getMessage());
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        String responseString = null;
        try {
            responseString = EntityUtils.toString(httpEntity);
        }
        catch (IOException e) {
            logger.debug("Failed to parse RedeemAccessToken response string from HTTP Entity", new Object[0]);
            throw new AuthenticationException(e.getMessage());
        }
        return responseString;
    }

    private HttpPost createHttpPostFromPayload(String payload) {
        String redeemAccessTokenEndpoint = this.endpoint + "/sso/redeem-token";
        HttpPost httpPost = new HttpPost(redeemAccessTokenEndpoint);
        StringEntity stringEntity = new StringEntity(payload, StandardCharsets.UTF_8);
        httpPost.setEntity(stringEntity);
        return httpPost;
    }

    private AwsSessionCredentials parseCredentialsFromResponse(String response) {
        JsonNode jsonNode = this.jsonNodeParser.parse(response);
        return jsonNode.field("credentials").map(JsonNode::asObject).map(c -> AwsSessionCredentials.create(((JsonNode)c.get("accessKeyId")).asString(), ((JsonNode)c.get("secretAccessKey")).asString(), ((JsonNode)c.get("sessionToken")).asString())).orElseThrow(() -> this.createRedeemAccessTokenException(jsonNode));
    }

    private AuthenticationException createRedeemAccessTokenException(JsonNode jsonNode) {
        Optional<JsonNode> error = jsonNode.field("message");
        if (error.isPresent()) {
            logger.info("Error occurred calling RedeemAccessToken: " + error.get().asString(), new Object[0]);
            return new AuthenticationException(String.format("Failed to retrieve DataZone domain execution role credentials: %s", error.get().asString()));
        }
        logger.info("Unable to determine error from RedeemAccessToken", new Object[0]);
        return new AuthenticationException("Unrecognized error while retrieving DataZone domain execution role credentials");
    }
}

