/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.configuration;

import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.logging.AthenaLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

public class UrlParser {
    private static final AthenaLogger logger = AthenaLogger.of(UrlParser.class);
    private static final ConnectionParameter<Void> NO_PARAMETER = new ConnectionParameter("");
    private final String preferredProtocol;
    private final Set<String> deprecatedProtocols;
    private final Set<String> optionalParameters;
    private final Map<String, ConnectionParameter<?>> parameterLookup;

    public UrlParser(String preferredProtocol, Set<String> deprecatedProtocols, Collection<ConnectionParameter<?>> optionalParameters) {
        this.preferredProtocol = preferredProtocol;
        this.deprecatedProtocols = deprecatedProtocols;
        this.optionalParameters = optionalParameters.stream().map(ConnectionParameter::name).map(String::toLowerCase).collect(Collectors.toSet());
        this.parameterLookup = optionalParameters.stream().flatMap(parameter -> parameter.allNames().stream().map(alias -> Pair.of(alias.toLowerCase(), parameter))).collect(Collectors.toMap(Pair::left, Pair::right));
    }

    public boolean isMatchingUrl(String url) {
        return !StringUtils.isEmpty(url) && this.startsWithASupportedProtocol(url);
    }

    private boolean startsWithASupportedProtocol(String url) {
        if (url.startsWith(this.preferredProtocol)) {
            return true;
        }
        for (String protocol : this.deprecatedProtocols) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    public Optional<Map<ConnectionParameter<?>, String>> parseUrl(String url, Map<String, String> defaults) {
        if (url == null) {
            throw new NullPointerException("The URL cannot be null");
        }
        if (!this.isMatchingUrl(url)) {
            return Optional.empty();
        }
        int dividerIndex = url.indexOf("://");
        if (dividerIndex == -1) {
            return Optional.of(this.cleanAndDeduplicateDefaults(defaults));
        }
        String protocol = url.substring(0, dividerIndex);
        if (!protocol.equals(this.preferredProtocol)) {
            logger.warn(String.format("The protocol \"%s\" is deprecated. Use \"%s\" instead", protocol, this.preferredProtocol), new Object[0]);
        }
        String parameterString = url.substring(protocol.length() + 3);
        return Optional.of(this.parseParameters(parameterString, this.cleanAndDeduplicateDefaults(defaults)));
    }

    private Map<ConnectionParameter<?>, String> cleanAndDeduplicateDefaults(Map<String, String> rawDefaults) {
        HashMap processedDefaults = new HashMap();
        rawDefaults.keySet().stream().filter(parameterName -> {
            boolean isEmpty = ((String)rawDefaults.get(parameterName)).isEmpty();
            if (isEmpty) {
                this.reportEmptyParameter((String)parameterName);
            }
            return !isEmpty;
        }).collect(Collectors.groupingBy(key -> this.parameterLookup.getOrDefault(key.toLowerCase(), NO_PARAMETER))).forEach((parameter, variants) -> {
            if (this.isKnownParameter((ConnectionParameter<?>)parameter, (List<String>)variants)) {
                processedDefaults.put((ConnectionParameter<?>)parameter, this.findPreferredDefaultValue((ConnectionParameter<?>)parameter, (List<String>)variants, rawDefaults));
            }
        });
        return processedDefaults;
    }

    private boolean isKnownParameter(ConnectionParameter<?> parameter, List<String> variants) {
        if (parameter == NO_PARAMETER) {
            for (String variant : variants) {
                this.reportIgnoredParameter(variant);
            }
            return false;
        }
        for (String variant : variants) {
            if (!parameter.isDeprecated(variant, true)) continue;
            this.reportDeprecatedParameter(variant, parameter.name());
        }
        return true;
    }

    private String findPreferredDefaultValue(ConnectionParameter<?> parameter, List<String> variants, Map<String, String> rawDefaults) {
        if (variants.size() == 1) {
            return rawDefaults.get(variants.get(0));
        }
        String preferredKey = parameter.findPreferredKey(rawDefaults).get();
        this.reportDuplicatedDefaultParameter(parameter.name(), preferredKey, variants.stream().filter(variant -> !variant.equals(preferredKey)).collect(Collectors.toList()));
        return rawDefaults.get(preferredKey);
    }

    private Map<ConnectionParameter<?>, String> parseParameters(String parameterString, Map<ConnectionParameter<?>, String> defaults) {
        HashMap parameters = new HashMap(defaults);
        int parameterStart = 0;
        Optional<String> host = this.findHost(parameterString);
        if (host.isPresent()) {
            parameters.put(ConnectionParameters.HOST, host.get());
            parameterStart += host.get().length() + 1;
        }
        while (parameterStart < parameterString.length()) {
            int parameterEnd = parameterString.indexOf(59, parameterStart);
            parameterEnd = parameterEnd == -1 ? parameterString.length() : parameterEnd;
            int equalsIndex = parameterString.indexOf(61, parameterStart);
            if (equalsIndex != -1 && equalsIndex < parameterEnd) {
                String key = parameterString.substring(parameterStart, equalsIndex);
                String normalizedKey = key.toLowerCase();
                String value = parameterString.substring(equalsIndex + 1, parameterEnd);
                ConnectionParameter<?> parameterDefinition = this.parameterLookup.get(normalizedKey);
                if (parameterDefinition == null) {
                    this.reportIgnoredParameter(key);
                } else if (value.isEmpty()) {
                    this.reportEmptyParameter(key);
                } else {
                    if (parameterDefinition.isDeprecated(key, false)) {
                        this.reportDeprecatedParameter(key, parameterDefinition.name());
                    }
                    if (parameters.containsKey(parameterDefinition)) {
                        this.reportDuplicatedUrlParameter(parameterDefinition.name());
                    }
                    parameters.put(parameterDefinition, value);
                }
            } else {
                String malformedParameter = parameterString.substring(parameterStart, parameterEnd);
                this.reportEmptyParameter(malformedParameter);
            }
            parameterStart = parameterEnd + 1;
        }
        return parameters;
    }

    private Optional<String> findHost(String parameterString) {
        int hostEnd = parameterString.indexOf(59);
        int n = hostEnd = hostEnd == -1 ? parameterString.length() : hostEnd;
        if (hostEnd > 0 && !parameterString.substring(0, hostEnd).contains("=")) {
            return Optional.of(parameterString.substring(0, hostEnd));
        }
        return Optional.empty();
    }

    private void reportIgnoredParameter(String name) {
        logger.warn("The connection parameter \"{}\" is unknown or unsupported and will be ignored", name);
    }

    private void reportEmptyParameter(String name) {
        logger.warn("The connection parameter \"{}\" was ignored because it was empty", name);
    }

    private void reportDeprecatedParameter(String deprecatedName, String preferredName) {
        logger.warn("The connection parameter \"{}\" is deprecated, use \"{}\"", deprecatedName, preferredName);
    }

    private void reportDuplicatedUrlParameter(String name) {
        logger.warn("The connection parameter \"{}\" (or its aliases) appears multiple times, only the last value will be used", name);
    }

    private void reportDuplicatedDefaultParameter(String parameterName, String usedName, Collection<String> ignoredKeys) {
        String ignoredKeysStr = ignoredKeys.stream().sorted().map(s -> String.format("\"%s\"", s)).collect(Collectors.joining(", "));
        logger.warn("Multiple aliases for the connection parameter \"{}\" were found in the defaults, only the value for \"{}\" will be used, {} will be ignored", parameterName, usedName, ignoredKeysStr);
    }
}

