/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.support.TypeInfoData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

public class TypeInfoResultSet
extends IteratorResultSetBase<TypeInfoData> {
    private static final String TYPE_NAME_COLUMN_NAME = "TYPE_NAME";
    private static final String DATA_TYPE_COLUMN_NAME = "DATA_TYPE";
    private static final String PRECISION_COLUMN_NAME = "PRECISION";
    private static final String LITERAL_PREFIX_COLUMN_NAME = "LITERAL_PREFIX";
    private static final String LITERAL_SUFFIX_COLUMN_NAME = "LITERAL_SUFFIX";
    private static final String CREATE_PARAMS_COLUMN_NAME = "CREATE_PARAMS";
    private static final String NULLABLE_COLUMN_NAME = "NULLABLE";
    private static final String CASE_SENSITIVE_COLUMN_NAME = "CASE_SENSITIVE";
    private static final String SEARCHABLE_COLUMN_NAME = "SEARCHABLE";
    private static final String UNSIGNED_ATTRIBUTE_COLUMN_NAME = "UNSIGNED_ATTRIBUTE";
    private static final String FIXED_PREC_SCALE_COLUMN_NAME = "FIXED_PREC_SCALE";
    private static final String AUTO_INCREMENT_COLUMN_NAME = "AUTO_INCREMENT";
    private static final String LOCAL_TYPE_NAME_COLUMN_NAME = "LOCAL_TYPE_NAME";
    private static final String MINIMUM_SCALE_COLUMN_NAME = "MINIMUM_SCALE";
    private static final String MAXIMUM_SCALE_COLUMN_NAME = "MAXIMUM_SCALE";
    private static final String SQL_DATA_TYPE_COLUMN_NAME = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB_COLUMN_NAME = "SQL_DATETIME_SUB";
    private static final String NUM_PREC_RADIX_COLUMN_NAME = "NUM_PREC_RADIX";
    private static final String TYPE_INFO_TABLE_NAME = "TYPE_INFO";
    private static final ResultSetMetadata META_DATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo((ColumnInfo)ColumnInfo.builder().label("TYPE_NAME").name("TYPE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("DATA_TYPE").name("DATA_TYPE").type(AthenaDataType.INTEGER.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("PRECISION").name("PRECISION").type(AthenaDataType.INTEGER.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("LITERAL_PREFIX").name("LITERAL_PREFIX").type(AthenaDataType.VARCHAR.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("LITERAL_SUFFIX").name("LITERAL_SUFFIX").type(AthenaDataType.VARCHAR.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("CREATE_PARAMS").name("CREATE_PARAMS").type(AthenaDataType.VARCHAR.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("NULLABLE").name("NULLABLE").type(AthenaDataType.SMALLINT.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("CASE_SENSITIVE").name("CASE_SENSITIVE").type(AthenaDataType.BOOLEAN.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("SEARCHABLE").name("SEARCHABLE").type(AthenaDataType.SMALLINT.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("UNSIGNED_ATTRIBUTE").name("UNSIGNED_ATTRIBUTE").type(AthenaDataType.BOOLEAN.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("FIXED_PREC_SCALE").name("FIXED_PREC_SCALE").type(AthenaDataType.BOOLEAN.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("AUTO_INCREMENT").name("AUTO_INCREMENT").type(AthenaDataType.BOOLEAN.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("LOCAL_TYPE_NAME").name("LOCAL_TYPE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("MINIMUM_SCALE").name("MINIMUM_SCALE").type(AthenaDataType.SMALLINT.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("MAXIMUM_SCALE").name("MAXIMUM_SCALE").type(AthenaDataType.SMALLINT.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("SQL_DATA_TYPE").name("SQL_DATA_TYPE").type(AthenaDataType.INTEGER.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("SQL_DATETIME_SUB").name("SQL_DATETIME_SUB").type(AthenaDataType.INTEGER.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("NUM_PREC_RADIX").name("NUM_PREC_RADIX").type(AthenaDataType.INTEGER.athenaName()).tableName("TYPE_INFO").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build()).build();

    public TypeInfoResultSet() {
        super(META_DATA);
    }

    @Override
    protected Iterator<TypeInfoData> iterator() {
        return Arrays.stream(AthenaDataType.values()).sorted(Comparator.comparing(AthenaDataType::jdbcType)).filter(val -> val.isResultType()).map(val -> new TypeInfoData(val.athenaName(), val.jdbcType(), val.maxSizeInBytes())).collect(Collectors.toList()).iterator();
    }

    @Override
    protected String stringValue(TypeInfoData row, int columnIndex) {
        switch (columnIndex) {
            case 1: 
            case 13: {
                return row.getTypeName();
            }
            case 2: {
                return String.valueOf(row.getDataType());
            }
            case 3: {
                int size = row.getPrecision();
                if (size == -1) {
                    return null;
                }
                return String.valueOf(size);
            }
        }
        return null;
    }
}

