/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.EscapeProcessor;
import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.TokenType;
import java.text.ParseException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Unescaper {
    static final Map<String, String> LITERAL_ESCAPE_TYPES = new HashMap<String, String>(){
        {
            this.put("d", "DATE");
            this.put("t", "TIME");
            this.put("ts", "TIMESTAMP");
            this.put("limit", "LIMIT");
            this.put("escape", "ESCAPE");
        }
    };
    private final Deque<Token> statement;

    Unescaper(List<Token> tokens) {
        this.statement = new LinkedList<Token>(tokens);
    }

    static List<Token> unescape(List<Token> tokens) throws ParseException {
        return new Unescaper(tokens).unescape();
    }

    List<Token> unescape() throws ParseException {
        LinkedList<Token> newTokens = new LinkedList<Token>();
        while (!this.statement.isEmpty()) {
            Token token = this.statement.removeFirst();
            if (token.type() == TokenType.ESCAPE_SEQUENCE_START) {
                Iterator<Token> replacementTokens = this.processEscapeSequence(this.statement).descendingIterator();
                while (replacementTokens.hasNext()) {
                    this.statement.addFirst(replacementTokens.next());
                }
                continue;
            }
            newTokens.add(token);
        }
        return newTokens;
    }

    private void skipWhitespace(Deque<Token> tokens) {
        while (!tokens.isEmpty() && tokens.peekFirst().isWhitespace()) {
            tokens.removeFirst();
        }
    }

    private Deque<Token> processEscapeSequence(Deque<Token> tokens) throws ParseException {
        LinkedList<Token> transformedTokens = new LinkedList<Token>();
        this.skipWhitespace(tokens);
        block6: while (!tokens.isEmpty()) {
            Token token = tokens.removeFirst();
            switch (token.type()) {
                case ESCAPE_SEQUENCE_END: {
                    break block6;
                }
                case ESCAPE_SEQUENCE_TYPE: {
                    String escapeSequenceType = token.value().toLowerCase();
                    String literalReplacement = LITERAL_ESCAPE_TYPES.get(escapeSequenceType);
                    if (literalReplacement != null) {
                        transformedTokens.add(Token.sql(literalReplacement));
                        transformedTokens.add(Token.space());
                        tokens.removeFirst();
                        continue block6;
                    }
                    if (escapeSequenceType.equals("oj")) {
                        transformedTokens.addAll(this.processOuterJoin(tokens));
                        continue block6;
                    }
                    if (!escapeSequenceType.equals("fn")) continue block6;
                    tokens.removeFirst();
                    continue block6;
                }
                case FUNCTION_NAME: {
                    transformedTokens.addAll(this.processFunctionCall(token, tokens));
                    continue block6;
                }
                case WHITESPACE: {
                    Token nextToken = tokens.peekFirst();
                    if (nextToken != null && nextToken.type() == TokenType.ESCAPE_SEQUENCE_END) continue block6;
                    transformedTokens.add(token);
                    continue block6;
                }
                default: {
                    transformedTokens.add(token);
                    continue block6;
                }
            }
        }
        return transformedTokens;
    }

    private List<Token> processFunctionCall(Token functionNameToken, Deque<Token> tokens) throws ParseException {
        boolean operatorCalledAsOperator;
        String functionName = functionNameToken.value();
        LinkedList<Token> newTokens = new LinkedList<Token>();
        JdbcFunction function = EscapeProcessor.FUNCTIONS.get(functionName.toUpperCase());
        this.skipWhitespace(tokens);
        boolean bl = operatorCalledAsOperator = function.isOperator() && (tokens.peekFirst() == null || tokens.peekFirst().type() != TokenType.FUNCTION_ARGUMENTS_START);
        if (operatorCalledAsOperator) {
            newTokens.add(Token.sql(function.athenaName()));
        } else {
            List<List<Token>> arguments = this.createArgumentList(tokens);
            try {
                newTokens.addAll(function.processFunctionCall(arguments));
            }
            catch (FunctionExpressionException e) {
                throw new ParseException(e.getMessage(), functionNameToken.startIndex());
            }
        }
        return newTokens;
    }

    private List<List<Token>> createArgumentList(Deque<Token> tokens) throws ParseException {
        LinkedList<List<Token>> arguments = new LinkedList<List<Token>>();
        LinkedList<Token> currentArgument = new LinkedList<Token>();
        tokens.removeFirst();
        block5: while (!tokens.isEmpty()) {
            Token argumentToken = tokens.removeFirst();
            switch (argumentToken.type()) {
                case FUNCTION_ARGUMENTS_END: {
                    if (arguments.isEmpty() && currentArgument.isEmpty()) break block5;
                    arguments.add(currentArgument);
                    break block5;
                }
                case FUNCTION_ARGUMENT_SEPARATOR: {
                    arguments.add(currentArgument);
                    currentArgument = new LinkedList();
                    continue block5;
                }
                case ESCAPE_SEQUENCE_START: {
                    currentArgument.addAll(this.processEscapeSequence(tokens));
                    continue block5;
                }
                default: {
                    currentArgument.add(argumentToken);
                    continue block5;
                }
            }
        }
        return arguments;
    }

    private List<Token> processOuterJoin(Deque<Token> tokens) throws ParseException {
        Token lastToken;
        LinkedList<Token> newTokens = new LinkedList<Token>();
        tokens.removeFirst();
        block4: while (!tokens.isEmpty()) {
            Token token = tokens.peekFirst();
            switch (token.type()) {
                case ESCAPE_SEQUENCE_START: {
                    newTokens.addAll(this.processEscapeSequence(tokens));
                    continue block4;
                }
                case ESCAPE_SEQUENCE_END: {
                    tokens.removeFirst();
                    break block4;
                }
                default: {
                    tokens.removeFirst();
                    newTokens.add(token);
                    continue block4;
                }
            }
        }
        if ((lastToken = (Token)newTokens.peekLast()) != null) {
            if (lastToken.isWhitespace()) {
                newTokens.removeLast();
            } else if (lastToken.type() == TokenType.SQL) {
                newTokens.removeLast();
                newTokens.add(Token.sql(lastToken.value().trim()));
            }
        }
        return newTokens;
    }
}

