/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.loader;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.StringJoiner;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.internal.http.loader.SdkHttpServiceProvider;
import software.amazon.awssdk.core.internal.http.loader.SdkServiceLoader;
import software.amazon.awssdk.http.SdkHttpService;
import software.amazon.awssdk.http.async.SdkAsyncHttpService;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class ClasspathSdkHttpServiceProvider<T>
implements SdkHttpServiceProvider<T> {
    static final Map<String, Integer> SYNC_HTTP_SERVICES_PRIORITY = ImmutableMap.builder().put("software.amazon.awssdk.http.apache.ApacheSdkHttpService", 1).put("software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService", 2).put("software.amazon.awssdk.http.crt.AwsCrtSdkHttpService", 3).build();
    static final Map<String, Integer> ASYNC_HTTP_SERVICES_PRIORITY = ImmutableMap.builder().put("software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService", 1).put("software.amazon.awssdk.http.crt.AwsCrtSdkHttpService", 2).build();
    private static final Logger log = Logger.loggerFor(ClasspathSdkHttpServiceProvider.class);
    private final Map<String, Integer> httpServicesPriority;
    private final SdkServiceLoader serviceLoader;
    private final Class<T> serviceClass;

    @SdkTestInternalApi
    ClasspathSdkHttpServiceProvider(SdkServiceLoader serviceLoader, Class<T> serviceClass, Map<String, Integer> httpServicesPriority) {
        this.serviceLoader = serviceLoader;
        this.serviceClass = serviceClass;
        this.httpServicesPriority = httpServicesPriority;
    }

    @Override
    public Optional<T> loadService() {
        PriorityQueue<Object> impls = new PriorityQueue<Object>(Comparator.comparingInt(o -> this.httpServicesPriority.getOrDefault(o.getClass().getName(), Integer.MAX_VALUE)));
        Iterable<Object> iterable = () -> this.serviceLoader.loadServices(this.serviceClass);
        iterable.forEach(impl -> impls.add(impl));
        if (impls.isEmpty()) {
            return Optional.empty();
        }
        log.debug(() -> this.logServices(impls));
        return Optional.of(impls.poll());
    }

    private String logServices(Queue<T> impls) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        int count = 0;
        for (Object clazz : impls) {
            String name = clazz.getClass().getName();
            joiner.add(name);
            ++count;
        }
        String implText = joiner.toString();
        T impl = impls.peek();
        String message = count == 1 ? "The HTTP implementation loaded is " + impl : String.format("Multiple HTTP implementations were found on the classpath. The SDK will use %s since it has the highest priority. The multiple implementations found were: %s", impl, implText);
        return message;
    }

    static SdkHttpServiceProvider<SdkHttpService> syncProvider() {
        return new ClasspathSdkHttpServiceProvider<SdkHttpService>(SdkServiceLoader.INSTANCE, SdkHttpService.class, SYNC_HTTP_SERVICES_PRIORITY);
    }

    static SdkHttpServiceProvider<SdkAsyncHttpService> asyncProvider() {
        return new ClasspathSdkHttpServiceProvider<SdkAsyncHttpService>(SdkServiceLoader.INSTANCE, SdkAsyncHttpService.class, ASYNC_HTTP_SERVICES_PRIORITY);
    }
}

