/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class SqsServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "sqs";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-ca-central-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("me-west-1"), Region.of("mx-central-1"), Region.of("sa-east-1"), Region.of("sa-west-1"), Region.of("us-catalyst-1"), Region.of("us-catalyst-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-northeast-1"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("fips-us-iso-east-1"), Region.of("us-iso-east-1"), Region.of("us-iso-west-1"), Region.of("us-isob-east-1"), Region.of("us-isob-west-1"), Region.of("eu-isoe-west-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1"), Region.of("eusc-de-east-1"), Region.of("ap-isog-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null), new DefaultServicePartitionMetadata("aws-iso-g", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), "us-iso-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), "us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.af-south-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-east-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-east-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-east-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-northeast-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-northeast-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-northeast-3.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-south-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-south-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-3.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-4.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-5.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-6.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).tags(EndpointTag.of("dualstack")).build(), "sqs.ap-southeast-7.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), "sqs-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ca-central-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("fips")).build(), "sqs-fips.ca-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.ca-west-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-central-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-central-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-north-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-south-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-south-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-west-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-west-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(), "sqs.eu-west-3.api.aws").put(ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), "sqs-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "sqs-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "sqs-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "sqs-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "sqs-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.il-central-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.me-central-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.me-south-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("me-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.me-west-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.mx-central-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.sa-east-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("sa-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.sa-west-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "sqs-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-east-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), "sqs-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-east-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-northeast-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), "sqs-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-west-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "sqs-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-west-2.api.aws").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.cn-north-1.api.amazonwebservices.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.cn-northwest-1.api.amazonwebservices.com.cn").put(ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), "sqs.us-iso-east-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-iso-east-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-iso-west-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-isob-east-1.sc2s.sgov.gov").put(ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-isob-west-1.sc2s.sgov.gov").put(ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-isof-east-1.csp.hci.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-isof-south-1.csp.hci.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), "sqs.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), "sqs.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-gov-east-1.api.aws").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), "sqs.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(), "sqs.us-gov-west-1.api.aws").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()), "sqs.{region}.{dnsSuffix}").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

