/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import java.util.Random;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.internal.backoff.BackoffStrategiesConstants;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ExponentialDelayWithJitter
implements BackoffStrategy {
    private final Supplier<Random> randomSupplier;
    private final Duration baseDelay;
    private final Duration maxDelay;

    public ExponentialDelayWithJitter(Supplier<Random> randomSupplier, Duration baseDelay, Duration maxDelay) {
        this.randomSupplier = Validate.paramNotNull(randomSupplier, "random");
        this.baseDelay = NumericUtils.min(Validate.isPositive(baseDelay, "baseDelay"), BackoffStrategiesConstants.BASE_DELAY_CEILING);
        this.maxDelay = NumericUtils.min(Validate.isPositive(maxDelay, "maxDelay"), BackoffStrategiesConstants.MAX_BACKOFF_CEILING);
    }

    @Override
    public Duration computeDelay(int attempt) {
        Validate.isPositive(attempt, "attempt");
        if (attempt == 1) {
            return Duration.ZERO;
        }
        int delay = BackoffStrategiesConstants.calculateExponentialDelay(attempt, this.baseDelay, this.maxDelay);
        int randInt = this.randomSupplier.get().nextInt(delay);
        return Duration.ofMillis(randInt);
    }

    public String toString() {
        return ToString.builder("ExponentialDelayWithJitter").add("baseDelay", this.baseDelay).add("maxDelay", this.maxDelay).build();
    }
}

