/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.ExecutorState;
import software.amazon.awssdk.services.athena.model.ExecutorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutorsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutorsSummary> {
    private static final SdkField<String> EXECUTOR_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExecutorId").getter(ExecutorsSummary.getter(ExecutorsSummary::executorId)).setter(ExecutorsSummary.setter(Builder::executorId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorId").build()).build();
    private static final SdkField<String> EXECUTOR_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExecutorType").getter(ExecutorsSummary.getter(ExecutorsSummary::executorTypeAsString)).setter(ExecutorsSummary.setter(Builder::executorType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorType").build()).build();
    private static final SdkField<Long> START_DATE_TIME_FIELD = SdkField.builder(MarshallingType.LONG).memberName("StartDateTime").getter(ExecutorsSummary.getter(ExecutorsSummary::startDateTime)).setter(ExecutorsSummary.setter(Builder::startDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();
    private static final SdkField<Long> TERMINATION_DATE_TIME_FIELD = SdkField.builder(MarshallingType.LONG).memberName("TerminationDateTime").getter(ExecutorsSummary.getter(ExecutorsSummary::terminationDateTime)).setter(ExecutorsSummary.setter(Builder::terminationDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationDateTime").build()).build();
    private static final SdkField<String> EXECUTOR_STATE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExecutorState").getter(ExecutorsSummary.getter(ExecutorsSummary::executorStateAsString)).setter(ExecutorsSummary.setter(Builder::executorState)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorState").build()).build();
    private static final SdkField<Long> EXECUTOR_SIZE_FIELD = SdkField.builder(MarshallingType.LONG).memberName("ExecutorSize").getter(ExecutorsSummary.getter(ExecutorsSummary::executorSize)).setter(ExecutorsSummary.setter(Builder::executorSize)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorSize").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTOR_ID_FIELD, EXECUTOR_TYPE_FIELD, START_DATE_TIME_FIELD, TERMINATION_DATE_TIME_FIELD, EXECUTOR_STATE_FIELD, EXECUTOR_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutorsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executorId;
    private final String executorType;
    private final Long startDateTime;
    private final Long terminationDateTime;
    private final String executorState;
    private final Long executorSize;

    private ExecutorsSummary(BuilderImpl builder) {
        this.executorId = builder.executorId;
        this.executorType = builder.executorType;
        this.startDateTime = builder.startDateTime;
        this.terminationDateTime = builder.terminationDateTime;
        this.executorState = builder.executorState;
        this.executorSize = builder.executorSize;
    }

    public final String executorId() {
        return this.executorId;
    }

    public final ExecutorType executorType() {
        return ExecutorType.fromValue(this.executorType);
    }

    public final String executorTypeAsString() {
        return this.executorType;
    }

    public final Long startDateTime() {
        return this.startDateTime;
    }

    public final Long terminationDateTime() {
        return this.terminationDateTime;
    }

    public final ExecutorState executorState() {
        return ExecutorState.fromValue(this.executorState);
    }

    public final String executorStateAsString() {
        return this.executorState;
    }

    public final Long executorSize() {
        return this.executorSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executorSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutorsSummary)) {
            return false;
        }
        ExecutorsSummary other = (ExecutorsSummary)obj;
        return Objects.equals(this.executorId(), other.executorId()) && Objects.equals(this.executorTypeAsString(), other.executorTypeAsString()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.terminationDateTime(), other.terminationDateTime()) && Objects.equals(this.executorStateAsString(), other.executorStateAsString()) && Objects.equals(this.executorSize(), other.executorSize());
    }

    public final String toString() {
        return ToString.builder("ExecutorsSummary").add("ExecutorId", this.executorId()).add("ExecutorType", this.executorTypeAsString()).add("StartDateTime", this.startDateTime()).add("TerminationDateTime", this.terminationDateTime()).add("ExecutorState", this.executorStateAsString()).add("ExecutorSize", this.executorSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutorId": {
                return Optional.ofNullable(clazz.cast(this.executorId()));
            }
            case "ExecutorType": {
                return Optional.ofNullable(clazz.cast(this.executorTypeAsString()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "TerminationDateTime": {
                return Optional.ofNullable(clazz.cast(this.terminationDateTime()));
            }
            case "ExecutorState": {
                return Optional.ofNullable(clazz.cast(this.executorStateAsString()));
            }
            case "ExecutorSize": {
                return Optional.ofNullable(clazz.cast(this.executorSize()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("ExecutorId", EXECUTOR_ID_FIELD);
        map.put("ExecutorType", EXECUTOR_TYPE_FIELD);
        map.put("StartDateTime", START_DATE_TIME_FIELD);
        map.put("TerminationDateTime", TERMINATION_DATE_TIME_FIELD);
        map.put("ExecutorState", EXECUTOR_STATE_FIELD);
        map.put("ExecutorSize", EXECUTOR_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutorsSummary, T> g) {
        return obj -> g.apply((ExecutorsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executorId;
        private String executorType;
        private Long startDateTime;
        private Long terminationDateTime;
        private String executorState;
        private Long executorSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutorsSummary model) {
            this.executorId(model.executorId);
            this.executorType(model.executorType);
            this.startDateTime(model.startDateTime);
            this.terminationDateTime(model.terminationDateTime);
            this.executorState(model.executorState);
            this.executorSize(model.executorSize);
        }

        public final String getExecutorId() {
            return this.executorId;
        }

        public final void setExecutorId(String executorId) {
            this.executorId = executorId;
        }

        @Override
        public final Builder executorId(String executorId) {
            this.executorId = executorId;
            return this;
        }

        public final String getExecutorType() {
            return this.executorType;
        }

        public final void setExecutorType(String executorType) {
            this.executorType = executorType;
        }

        @Override
        public final Builder executorType(String executorType) {
            this.executorType = executorType;
            return this;
        }

        @Override
        public final Builder executorType(ExecutorType executorType) {
            this.executorType(executorType == null ? null : executorType.toString());
            return this;
        }

        public final Long getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Long startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Long startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Long getTerminationDateTime() {
            return this.terminationDateTime;
        }

        public final void setTerminationDateTime(Long terminationDateTime) {
            this.terminationDateTime = terminationDateTime;
        }

        @Override
        public final Builder terminationDateTime(Long terminationDateTime) {
            this.terminationDateTime = terminationDateTime;
            return this;
        }

        public final String getExecutorState() {
            return this.executorState;
        }

        public final void setExecutorState(String executorState) {
            this.executorState = executorState;
        }

        @Override
        public final Builder executorState(String executorState) {
            this.executorState = executorState;
            return this;
        }

        @Override
        public final Builder executorState(ExecutorState executorState) {
            this.executorState(executorState == null ? null : executorState.toString());
            return this;
        }

        public final Long getExecutorSize() {
            return this.executorSize;
        }

        public final void setExecutorSize(Long executorSize) {
            this.executorSize = executorSize;
        }

        @Override
        public final Builder executorSize(Long executorSize) {
            this.executorSize = executorSize;
            return this;
        }

        @Override
        public ExecutorsSummary build() {
            return new ExecutorsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutorsSummary> {
        public Builder executorId(String var1);

        public Builder executorType(String var1);

        public Builder executorType(ExecutorType var1);

        public Builder startDateTime(Long var1);

        public Builder terminationDateTime(Long var1);

        public Builder executorState(String var1);

        public Builder executorState(ExecutorState var1);

        public Builder executorSize(Long var1);
    }
}

