/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.ExecutorsSummary;
import software.amazon.awssdk.services.athena.model.ExecutorsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutorsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListExecutorsResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SessionId").getter(ListExecutorsResponse.getter(ListExecutorsResponse::sessionId)).setter(ListExecutorsResponse.setter(Builder::sessionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListExecutorsResponse.getter(ListExecutorsResponse::nextToken)).setter(ListExecutorsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<List<ExecutorsSummary>> EXECUTORS_SUMMARY_FIELD = SdkField.builder(MarshallingType.LIST).memberName("ExecutorsSummary").getter(ListExecutorsResponse.getter(ListExecutorsResponse::executorsSummary)).setter(ListExecutorsResponse.setter(Builder::executorsSummary)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorsSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ExecutorsSummary::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, NEXT_TOKEN_FIELD, EXECUTORS_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExecutorsResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String nextToken;
    private final List<ExecutorsSummary> executorsSummary;

    private ListExecutorsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.nextToken = builder.nextToken;
        this.executorsSummary = builder.executorsSummary;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasExecutorsSummary() {
        return this.executorsSummary != null && !(this.executorsSummary instanceof SdkAutoConstructList);
    }

    public final List<ExecutorsSummary> executorsSummary() {
        return this.executorsSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutorsSummary() ? this.executorsSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutorsResponse)) {
            return false;
        }
        ListExecutorsResponse other = (ListExecutorsResponse)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasExecutorsSummary() == other.hasExecutorsSummary() && Objects.equals(this.executorsSummary(), other.executorsSummary());
    }

    public final String toString() {
        return ToString.builder("ListExecutorsResponse").add("SessionId", this.sessionId()).add("NextToken", this.nextToken()).add("ExecutorsSummary", this.hasExecutorsSummary() ? this.executorsSummary() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ExecutorsSummary": {
                return Optional.ofNullable(clazz.cast(this.executorsSummary()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ExecutorsSummary", EXECUTORS_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutorsResponse, T> g) {
        return obj -> g.apply((ListExecutorsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String nextToken;
        private List<ExecutorsSummary> executorsSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutorsResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.nextToken(model.nextToken);
            this.executorsSummary(model.executorsSummary);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ExecutorsSummary.Builder> getExecutorsSummary() {
            List<ExecutorsSummary.Builder> result = ExecutorsSummaryListCopier.copyToBuilder(this.executorsSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutorsSummary(Collection<ExecutorsSummary.BuilderImpl> executorsSummary) {
            this.executorsSummary = ExecutorsSummaryListCopier.copyFromBuilder(executorsSummary);
        }

        @Override
        public final Builder executorsSummary(Collection<ExecutorsSummary> executorsSummary) {
            this.executorsSummary = ExecutorsSummaryListCopier.copy(executorsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executorsSummary(ExecutorsSummary ... executorsSummary) {
            this.executorsSummary(Arrays.asList(executorsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executorsSummary(Consumer<ExecutorsSummary.Builder> ... executorsSummary) {
            this.executorsSummary(Stream.of(executorsSummary).map(c -> (ExecutorsSummary)((ExecutorsSummary.Builder)ExecutorsSummary.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListExecutorsResponse build() {
            return new ListExecutorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutorsResponse> {
        public Builder sessionId(String var1);

        public Builder nextToken(String var1);

        public Builder executorsSummary(Collection<ExecutorsSummary> var1);

        public Builder executorsSummary(ExecutorsSummary ... var1);

        public Builder executorsSummary(Consumer<ExecutorsSummary.Builder> ... var1);
    }
}

