/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.Row;
import software.amazon.awssdk.services.athena.model.RowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSet> {
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Rows").getter(ResultSet.getter(ResultSet::rows)).setter(ResultSet.setter(Builder::rows)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(Row::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<ResultSetMetadata> RESULT_SET_METADATA_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("ResultSetMetadata").getter(ResultSet.getter(ResultSet::resultSetMetadata)).setter(ResultSet.setter(Builder::resultSetMetadata)).constructor(ResultSetMetadata::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSetMetadata").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD, RESULT_SET_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Row> rows;
    private final ResultSetMetadata resultSetMetadata;

    private ResultSet(BuilderImpl builder) {
        this.rows = builder.rows;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<Row> rows() {
        return this.rows;
    }

    public final ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSetMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        return this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && Objects.equals(this.resultSetMetadata(), other.resultSetMetadata());
    }

    public final String toString() {
        return ToString.builder("ResultSet").add("Rows", this.hasRows() ? this.rows() : null).add("ResultSetMetadata", this.resultSetMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "ResultSetMetadata": {
                return Optional.ofNullable(clazz.cast(this.resultSetMetadata()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Rows", ROWS_FIELD);
        map.put("ResultSetMetadata", RESULT_SET_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultSet, T> g) {
        return obj -> g.apply((ResultSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();
        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            this.rows(model.rows);
            this.resultSetMetadata(model.resultSetMetadata);
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (Row)((Row.Builder)Row.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return this.resultSetMetadata != null ? this.resultSetMetadata.toBuilder() : null;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        @Override
        public ResultSet build() {
            return new ResultSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSet> {
        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder rows(Consumer<Row.Builder> ... var1);

        public Builder resultSetMetadata(ResultSetMetadata var1);

        default public Builder resultSetMetadata(Consumer<ResultSetMetadata.Builder> resultSetMetadata) {
            return this.resultSetMetadata((ResultSetMetadata)ResultSetMetadata.builder().applyMutation(resultSetMetadata).build());
        }
    }
}

