/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.SessionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionStatus> {
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("StartDateTime").getter(SessionStatus.getter(SessionStatus::startDateTime)).setter(SessionStatus.setter(Builder::startDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("LastModifiedDateTime").getter(SessionStatus.getter(SessionStatus::lastModifiedDateTime)).setter(SessionStatus.setter(Builder::lastModifiedDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDateTime").build()).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("EndDateTime").getter(SessionStatus.getter(SessionStatus::endDateTime)).setter(SessionStatus.setter(Builder::endDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();
    private static final SdkField<Instant> IDLE_SINCE_DATE_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("IdleSinceDateTime").getter(SessionStatus.getter(SessionStatus::idleSinceDateTime)).setter(SessionStatus.setter(Builder::idleSinceDateTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleSinceDateTime").build()).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("State").getter(SessionStatus.getter(SessionStatus::stateAsString)).setter(SessionStatus.setter(Builder::state)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();
    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StateChangeReason").getter(SessionStatus.getter(SessionStatus::stateChangeReason)).setter(SessionStatus.setter(Builder::stateChangeReason)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_TIME_FIELD, LAST_MODIFIED_DATE_TIME_FIELD, END_DATE_TIME_FIELD, IDLE_SINCE_DATE_TIME_FIELD, STATE_FIELD, STATE_CHANGE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant startDateTime;
    private final Instant lastModifiedDateTime;
    private final Instant endDateTime;
    private final Instant idleSinceDateTime;
    private final String state;
    private final String stateChangeReason;

    private SessionStatus(BuilderImpl builder) {
        this.startDateTime = builder.startDateTime;
        this.lastModifiedDateTime = builder.lastModifiedDateTime;
        this.endDateTime = builder.endDateTime;
        this.idleSinceDateTime = builder.idleSinceDateTime;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final Instant idleSinceDateTime() {
        return this.idleSinceDateTime;
    }

    public final SessionState state() {
        return SessionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateChangeReason() {
        return this.stateChangeReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSinceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionStatus)) {
            return false;
        }
        SessionStatus other = (SessionStatus)obj;
        return Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.lastModifiedDateTime(), other.lastModifiedDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.idleSinceDateTime(), other.idleSinceDateTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason());
    }

    public final String toString() {
        return ToString.builder("SessionStatus").add("StartDateTime", this.startDateTime()).add("LastModifiedDateTime", this.lastModifiedDateTime()).add("EndDateTime", this.endDateTime()).add("IdleSinceDateTime", this.idleSinceDateTime()).add("State", this.stateAsString()).add("StateChangeReason", this.stateChangeReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "LastModifiedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "IdleSinceDateTime": {
                return Optional.ofNullable(clazz.cast(this.idleSinceDateTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("StartDateTime", START_DATE_TIME_FIELD);
        map.put("LastModifiedDateTime", LAST_MODIFIED_DATE_TIME_FIELD);
        map.put("EndDateTime", END_DATE_TIME_FIELD);
        map.put("IdleSinceDateTime", IDLE_SINCE_DATE_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionStatus, T> g) {
        return obj -> g.apply((SessionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startDateTime;
        private Instant lastModifiedDateTime;
        private Instant endDateTime;
        private Instant idleSinceDateTime;
        private String state;
        private String stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionStatus model) {
            this.startDateTime(model.startDateTime);
            this.lastModifiedDateTime(model.lastModifiedDateTime);
            this.endDateTime(model.endDateTime);
            this.idleSinceDateTime(model.idleSinceDateTime);
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public final void setLastModifiedDateTime(Instant lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }

        @Override
        public final Builder lastModifiedDateTime(Instant lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final Instant getIdleSinceDateTime() {
            return this.idleSinceDateTime;
        }

        public final void setIdleSinceDateTime(Instant idleSinceDateTime) {
            this.idleSinceDateTime = idleSinceDateTime;
        }

        @Override
        public final Builder idleSinceDateTime(Instant idleSinceDateTime) {
            this.idleSinceDateTime = idleSinceDateTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        @Override
        public SessionStatus build() {
            return new SessionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionStatus> {
        public Builder startDateTime(Instant var1);

        public Builder lastModifiedDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder idleSinceDateTime(Instant var1);

        public Builder state(String var1);

        public Builder state(SessionState var1);

        public Builder stateChangeReason(String var1);
    }
}

