/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.NotebookType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotebookRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, UpdateNotebookRequest> {
    private static final SdkField<String> NOTEBOOK_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NotebookId").getter(UpdateNotebookRequest.getter(UpdateNotebookRequest::notebookId)).setter(UpdateNotebookRequest.setter(Builder::notebookId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookId").build()).build();
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Payload").getter(UpdateNotebookRequest.getter(UpdateNotebookRequest::payload)).setter(UpdateNotebookRequest.setter(Builder::payload)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Type").getter(UpdateNotebookRequest.getter(UpdateNotebookRequest::typeAsString)).setter(UpdateNotebookRequest.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SessionId").getter(UpdateNotebookRequest.getter(UpdateNotebookRequest::sessionId)).setter(UpdateNotebookRequest.setter(Builder::sessionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateNotebookRequest.getter(UpdateNotebookRequest::clientRequestToken)).setter(UpdateNotebookRequest.setter(Builder::clientRequestToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_ID_FIELD, PAYLOAD_FIELD, TYPE_FIELD, SESSION_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNotebookRequest.memberNameToFieldInitializer();
    private final String notebookId;
    private final String payload;
    private final String type;
    private final String sessionId;
    private final String clientRequestToken;

    private UpdateNotebookRequest(BuilderImpl builder) {
        super(builder);
        this.notebookId = builder.notebookId;
        this.payload = builder.payload;
        this.type = builder.type;
        this.sessionId = builder.sessionId;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String notebookId() {
        return this.notebookId;
    }

    public final String payload() {
        return this.payload;
    }

    public final NotebookType type() {
        return NotebookType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotebookRequest)) {
            return false;
        }
        UpdateNotebookRequest other = (UpdateNotebookRequest)obj;
        return Objects.equals(this.notebookId(), other.notebookId()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder("UpdateNotebookRequest").add("NotebookId", this.notebookId()).add("Payload", this.payload()).add("Type", this.typeAsString()).add("SessionId", this.sessionId()).add("ClientRequestToken", this.clientRequestToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookId": {
                return Optional.ofNullable(clazz.cast(this.notebookId()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NotebookId", NOTEBOOK_ID_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotebookRequest, T> g) {
        return obj -> g.apply((UpdateNotebookRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String notebookId;
        private String payload;
        private String type;
        private String sessionId;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotebookRequest model) {
            super(model);
            this.notebookId(model.notebookId);
            this.payload(model.payload);
            this.type(model.type);
            this.sessionId(model.sessionId);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getNotebookId() {
            return this.notebookId;
        }

        public final void setNotebookId(String notebookId) {
            this.notebookId = notebookId;
        }

        @Override
        public final Builder notebookId(String notebookId) {
            this.notebookId = notebookId;
            return this;
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotebookType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotebookRequest build() {
            return new UpdateNotebookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNotebookRequest> {
        public Builder notebookId(String var1);

        public Builder payload(String var1);

        public Builder type(String var1);

        public Builder type(NotebookType var1);

        public Builder sessionId(String var1);

        public Builder clientRequestToken(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

