/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;

public class ListApplicationDPUSizesIterable
implements SdkIterable<ListApplicationDpuSizesResponse> {
    private final AthenaClient client;
    private final ListApplicationDpuSizesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationDPUSizesIterable(AthenaClient client, ListApplicationDpuSizesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationDpuSizesResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationDpuSizesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationDpuSizesResponseFetcher
    implements SyncPageFetcher<ListApplicationDpuSizesResponse> {
        private ListApplicationDpuSizesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationDpuSizesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationDpuSizesResponse nextPage(ListApplicationDpuSizesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationDPUSizesIterable.this.client.listApplicationDPUSizes(ListApplicationDPUSizesIterable.this.firstRequest);
            }
            return ListApplicationDPUSizesIterable.this.client.listApplicationDPUSizes((ListApplicationDpuSizesRequest)ListApplicationDPUSizesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

