/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;

public class ListCalculationExecutionsIterable
implements SdkIterable<ListCalculationExecutionsResponse> {
    private final AthenaClient client;
    private final ListCalculationExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCalculationExecutionsIterable(AthenaClient client, ListCalculationExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCalculationExecutionsResponseFetcher();
    }

    @Override
    public Iterator<ListCalculationExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCalculationExecutionsResponseFetcher
    implements SyncPageFetcher<ListCalculationExecutionsResponse> {
        private ListCalculationExecutionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListCalculationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListCalculationExecutionsResponse nextPage(ListCalculationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListCalculationExecutionsIterable.this.client.listCalculationExecutions(ListCalculationExecutionsIterable.this.firstRequest);
            }
            return ListCalculationExecutionsIterable.this.client.listCalculationExecutions((ListCalculationExecutionsRequest)ListCalculationExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

