/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;

public class ListSessionsPublisher
implements SdkPublisher<ListSessionsResponse> {
    private final AthenaAsyncClient client;
    private final ListSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionsPublisher(AthenaAsyncClient client, ListSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionsPublisher(AthenaAsyncClient client, ListSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListSessionsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSessionsResponseFetcher
    implements AsyncPageFetcher<ListSessionsResponse> {
        private ListSessionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListSessionsResponse> nextPage(ListSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsPublisher.this.client.listSessions(ListSessionsPublisher.this.firstRequest);
            }
            return ListSessionsPublisher.this.client.listSessions((ListSessionsRequest)ListSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

